let uiList = []
function joinList(id, type) {
  uiList.push({ id: id, type: type })
}

function 获取控件列表(state) {
  if (state == undefined) {
    state = 15
  }
  let list = {}
  for (let i = 0; i < uiList.length; i++) {
    let value;
    if (uiList[i].type == '单选框' || uiList[i].type == '复选框') {
      if (state & 1) {
        value = document.getElementById(uiList[i].id + '_选项').checked
        list[uiList[i].id] = {
          选择状态: value
        }
      }
    } else if (uiList[i].type == '文本框' || uiList[i].type == '多行文本框') {
      if (state & 2) {
        value = document.getElementById(uiList[i].id).value
        list[uiList[i].id] = {
          输入文本: value
        }

      }
    } else if (uiList[i].type == '列表框') {
      if (state & 4) {
        value = document.getElementById(uiList[i].id).dataset.value
        index = document.getElementById(uiList[i].id).dataset.index
        list[uiList[i].id] = {
          选择行: index,
          选择文本: value
        }
      }
    } else if (uiList[i].type == '下拉列表') {
      if (state & 4) {
        value = document.getElementById(uiList[i].id).dataset.value
        index = document.getElementById(uiList[i].id).dataset.index
        list[uiList[i].id] = {
          选择行: index,
          选择文本: value
        }
      }
    } else if (uiList[i].type == '穿梭框') {
      if (state & 8) {
        value = 获取穿梭框源列表(uiList[i].id)
        target = 获取穿梭框目标列表(uiList[i].id)
        list[uiList[i].id] = {
          源列表: value,
          目标列表: target
        }
      }
    }
  }
  return JSON.stringify(list)
}
// 定义一个函数，用于转义JSON字符串中的控制字符
function escapeControlCharacters(jsonString) {
  const escapeMap = {
    '\b': '\\b',
    '\t': '\\t',
    '\n': '\\n',
    '\f': '\\f',
    '\r': '\\r',
  };
  return jsonString.replace(/[\b\t\n\f\r]/g, (char) => escapeMap[char]);
}

function 设置控件值(json) {
  let list
  try {
    list = JSON.parse(json)
  } catch (e) {
    let escapeJson = escapeControlCharacters(json)
    list = JSON.parse(escapeJson)
  }

  for (const key in list) {
    if (list[key]) {
      if (list[key].选择状态 != undefined) {
        document.getElementById(key + '_选项').checked = list[key].选择状态
      } else if (list[key].输入文本 != undefined) {
        document.getElementById(key).value = list[key].输入文本
      } else if (list[key].选择文本 != undefined) {
        if (document.getElementById(key).classList.contains('下拉-下拉')) {
          let dropdown = document.getElementById(key)
          let selected = dropdown.firstElementChild
          let options = dropdown.lastElementChild
          let optionIndex = -1
          let option = options.querySelectorAll("div")
          option.forEach((item, index) => {
            if (item.innerHTML == list[key].选择文本) {
              optionIndex = index
            }
          })
          if (optionIndex < 0) {
            console.error('无法找到选项:' + list[key].选择文本)
          } else {
            dropdown.dataset.value = list[key].选择文本
            dropdown.dataset.index = optionIndex
            selected.firstElementChild.innerHTML = list[key].选择文本;
            option.forEach((item, index) => {
              if (index == optionIndex) {
                item.classList.add('same-as-selected')
              } else {
                item.classList.remove('same-as-selected')
              }
            })
          }
        } else {
          let div = document.querySelector('#' + key);
          div.dataset.value = list[key].选择文本
          div.querySelectorAll('div').forEach((item, index) => {
            if (item.innerHTML == list[key].选择文本) {
              item.classList.add('selected')
              div.dataset.index = index
            } else {
              item.classList.remove('selected')
            }
          })
        }
      } else if (list[key].选择行 != undefined) {
        if (document.getElementById(key).classList.contains('下拉-下拉')) {
          let dropdown = document.getElementById(key)
          let selected = dropdown.firstElementChild
          let options = dropdown.lastElementChild
          let value = ''
          let option = options.querySelectorAll("div")
          option.forEach((item, index) => {
            if (index == list[key].选择行) {
              value = item.innerHTML
            }
          })
          if (value == '') {
            console.error('无法找到选项：' + key + " 的选择行 " + list[key].选择行)
          } else {
            dropdown.dataset.value = value
            dropdown.dataset.index = list[key].选择行
            selected.firstElementChild.innerHTML = value;
            option.forEach((item, index) => {
              if (index == list[key].选择行) {
                item.classList.add('same-as-selected')
              } else {
                item.classList.remove('same-as-selected')
              }
            })
          }
        } else {
          let div = document.querySelector('#' + key);
          div.dataset.index = list[key].选择行
          div.querySelectorAll('div').forEach((item, index) => {
            if (index == list[key].选择行) {
              item.classList.add('selected')
              div.dataset.value = item.innerHTML
            } else {
              item.classList.remove('selected')
            }
          })
        }

      } else if (list[key].源列表 != undefined || list[key].目标列表 != undefined) {
        let resList = [...list[key].源列表, ...list[key].目标列表]
        let totalList = [...获取穿梭框源列表(key), ...获取穿梭框目标列表(key)]
        if (isArrEqual(resList, totalList)) {
          // console.log('列表相同')
          if (list[key].源列表 != undefined) {
            设置源列表(key, list[key].源列表)
          }
          if (list[key].目标列表 != undefined) {
            设置目标列表(key, list[key].目标列表)
          }
        }

      }
    }
  }
}

const isArrEqual = (arr1, arr2) => {
  return arr1.length === arr2.length && arr1.every((ele) => arr2.includes(ele));
};

function 获取单选框值(id) {
  return document.getElementById(id + '_选项').checked
}

function 获取单选框组选中ID(name) {
  let radios = document.getElementsByName(name)
  for (let i = 0; i < radios.length; i++) {
    if (radios[i].checked) {
      return radios[i].id.slice(0, -3)
    }
  }
}

function 获取复选框值(id) {
  return document.getElementById(id + '_选项').checked
}

function 获取下拉框选择文本(id) {
  return document.getElementById(id).dataset.value
}
function 获取下拉框选择行(id) {
  return document.getElementById(id).dataset.index
}

function 获取列表框选择文本(id) {
  return document.getElementById(id).dataset.value
}
function 获取列表框选择行(id) {
  return document.getElementById(id).dataset.index
}
function 获取文本框文本(id) {
  return document.getElementById(id).value
}

function 创建水平布局(id, parent) {
  var div = document.createElement('div')
  div.id = id
  div.style.width = '100%'
  div.style.display = 'flex'
  if (parent) {
    let uiparent = document.getElementById(parent)
    uiparent.appendChild(div)
  } else {
    document.body.appendChild(div)
  }

}

function 创建垂直布局(id, parent) {
  var div = document.createElement('div')
  div.id = id
  div.style.width = '100%'
  div.style.display = 'flex'
  div.style.flexDirection = 'column'
  if (parent) {
    let uiparent = document.getElementById(parent)
    uiparent.appendChild(div)
  } else {
    document.body.appendChild(div)
  }
}

function 设置布局排列(id, type) {
  let set = 'normal'
  if (type == '居中') {
    set = 'center'
  } else if (type == '靠左') {
    set = 'flex-start'
  } else if (type == '靠右') {
    set = 'flex-end'
  } else if (type == '两端') {
    set = 'space-between'
  } else if (type == '环绕') {
    set = 'space-around'
  } else if (type == '平均') {
    set = 'space-evenly'
  }
  document.getElementById(id).style.justifyContent = set
}

function 设置布局垂直排列(id, type) {
  let set = 'normal'
  if (type == '居中') {
    set = 'center'
  } else if (type == '靠上') {
    set = 'flex-start'
  } else if (type == '靠下') {
    set = 'flex-end'
  } else if (type == '基线') {
    set = 'baseline'
  } else if (type == '拉伸') {
    set = 'stretch'
  }
  document.getElementById(id).style.alignItems = set
}

function 创建按钮(id, text, parent) {
  var btn = document.createElement('button')
  btn.id = id
  btn.classList.add('button1')
  btn.style.width = '100%'
  btn.innerHTML = text
  if (parent) {
    let uiparent = document.getElementById(parent)
    uiparent.appendChild(btn)
  } else {
    document.body.appendChild(btn)
  }
  joinList(id, '按钮')
}

function 创建标签(id, text, parent) {
  var span = document.createElement('span')
  span.id = id
  span.style.width = '100%'
  span.innerHTML = text
  if (parent) {
    let uiparent = document.getElementById(parent)
    uiparent.appendChild(span)
  } else {
    document.body.appendChild(span)
  }
  joinList(id, '标签')
}

function 创建单选框(id, text, group, parent) {
  // 创建标签元素
  const label = document.createElement('label');
  label.className = 'inputLabel';
  label.id = id;
  // 创建隐藏的单选按钮
  const radio = document.createElement('input');
  radio.type = 'radio';
  radio.name = group; // 确保组内唯一
  radio.id = id + '_选项';
  radio.style.display = 'none';


  // 创建可视的自定义单选样式
  const customRadio = document.createElement('span');
  customRadio.className = 'custom-单选1';

  // 组装标签内的元素
  label.appendChild(radio);
  label.appendChild(customRadio);
  let span = document.createElement('span');
  span.style.display = 'flex';
  span.style.alignItems = 'center';
  span.innerHTML = text;
  label.appendChild(span);

  if (parent) {
    let uiparent = document.getElementById(parent)
    uiparent.appendChild(label)
  }
  else {
    document.body.appendChild(label)
  }
  joinList(id, '单选框')
}


//复选框1函数
function 创建复选框(id, text, parent) {

  // 创建 label 元素
  const label = document.createElement('label');
  label.className = 'inputLabel';
  label.id = id;
  // 创建 checkbox input 元素
  const checkbox = document.createElement('input');
  checkbox.type = 'checkbox';
  checkbox.id = id + '_选项';
  checkbox.style.display = 'none';
  // 创建自定义复选框 span 元素
  const customCheckbox = document.createElement('span');
  customCheckbox.className = '复选1-checkbox';

  // 将这些元素添加到 label 中
  label.appendChild(checkbox);
  label.appendChild(customCheckbox);
  let span = document.createElement('span');
  span.style.display = 'flex';
  span.style.alignItems = 'center';
  span.innerHTML = text;
  label.appendChild(span);

  // 将 label 添加到指定容器中
  if (parent) {
    let uiparent = document.getElementById(parent)
    uiparent.appendChild(label)
  } else {
    document.body.appendChild(label)
  }
  joinList(id, '复选框')
}


function 创建文本框(id, defaultText, parent) {
  if (defaultText == null) {
    defaultText = ''
  }
  var input = document.createElement('input')
  input.style.width = '100%'
  input.id = id
  input.type = 'text'; // 设置输入框类型
  input.className = '文本框';
  input.placeholder = defaultText; // 设置默认文本
  if (parent) {
    let uiparent = document.getElementById(parent)
    uiparent.appendChild(input)
  } else {
    document.body.appendChild(input)
  }
  joinList(id, '文本框')
}

function 创建多行文本框(id, resize, parent) {
  if (resize == '不可拖动') {
    resize = 'none'
  } else {
    resize = ''
  }
  var textarea = document.createElement('textarea')
  textarea.style.width = '100%'
  textarea.id = id
  textarea.className = '文本框';
  textarea.style.resize = resize;
  if (parent) {
    let uiparent = document.getElementById(parent)
    uiparent.appendChild(textarea)
  } else {
    document.body.appendChild(textarea)
  }
  joinList(id, '多行文本框')
}
function 创建列表框(id, parent) {
  var div = document.createElement('div')
  div.style.width = '100%'
  div.id = id
  div.className = 'list'
  if (parent) {
    let uiparent = document.getElementById(parent)
    uiparent.appendChild(div)
  } else {
    document.body.appendChild(div)
  }
  joinList(id, '列表框')
}

let eventList = {}

let dropdownShow = null
function 创建下拉列表(id, parent, options) {
  let container
  if (parent == null || parent == '') {
    container = document.body
  } else {
    container = document.getElementById(parent)
  }
  // 获取容器元素

  // 创建下拉列表的主容器
  const dropdown = document.createElement('div');
  dropdown.className = '下拉-下拉';
  dropdown.id = id
  dropdown.dataset.value = options[0];
  dropdown.dataset.index = 0;
  // 创建显示已选择项的容器
  const selected = document.createElement('div');
  selected.className = '下拉-selected 下拉-箭头-down';
  // 默认选择第一个选项
  selected.innerHTML = `<span style="display: flex; align-items: center;">${options[0]}</span><span class="箭头"></span>`;
  dropdown.appendChild(selected);

  // 创建下拉项的容器
  const itemsContainer = document.createElement('div');

  itemsContainer.className = '下拉-items';
  itemsContainer.style.position = 'fixed'

  // 遍历选项数组并创建下拉项
  options.forEach((option, index) => {
    const item = document.createElement('div');
    item.style.display = 'flex';
    item.style.alignItems = 'center'
    item.innerHTML = option;
    // 为第一个选项添加选中样式
    if (index === 0) {
      item.classList.add('same-as-selected');
    }
    // 点击事件处理
    item.addEventListener('click', function () {
      selected.firstElementChild.innerHTML = this.innerHTML;
      // 更新选中的样式
      itemsContainer.querySelectorAll('div').forEach(opt => opt.classList.remove('same-as-selected'));
      this.classList.add('same-as-selected');
      dropdown.dataset.value = this.innerHTML;
      dropdown.dataset.index = index;
      // 隐藏下拉项并恢复箭头方向
      itemsContainer.style.display = 'none';
      selected.classList.add('下拉-箭头-down');
      selected.classList.remove('下拉-箭头-up');
      selected.classList.remove('active');
      // dropdown.style.zIndex = ''; // 取消置前效果
      if (eventList[id] != null) {
        eventList[id]();
      }
    });
    itemsContainer.appendChild(item);
  });

  // 将下拉项容器添加到主容器中
  dropdown.appendChild(itemsContainer);
  // 将完整的下拉框添加到指定的HTML容器中
  container.appendChild(dropdown);

  // 处理下拉框的点击事件，展开或收起下拉列表
  selected.addEventListener('click', function (event) {
    if (dropdownShow != null && dropdownShow[0] != itemsContainer) {
      dropdownShow[0].style.display = 'none';
      dropdownShow[1].classList.add('下拉-箭头-down');
      dropdownShow[1].classList.remove('下拉-箭头-up');
      dropdownShow[1].classList.remove('下拉-active');
    }
    event.stopPropagation(); // 阻止事件冒泡
    const isOpen = itemsContainer.style.display === 'block';
    itemsContainer.style.display = isOpen ? 'none' : 'block';

    if (!isOpen) {
      itemsContainer.style.zIndex = '1000'; // 将控件置前
      // 新打开时，计算下拉项是否超出窗口

      var rect = selected.getBoundingClientRect();
      var bottomPosition = rect.bottom;
      itemsContainer.style.top = bottomPosition + 'px';
      itemsContainer.style.left = rect.left + 'px';
      itemsContainer.style.width = rect.width + 'px';
      const bounding = dropdown.getBoundingClientRect();
      if (bounding.bottom + itemsContainer.offsetHeight > window.innerHeight) {
        itemsContainer.style.maxHeight = '150px';
      } else {
        itemsContainer.style.maxHeight = '150px'; // 重置为默认高度
      }

      dropdownShow = [itemsContainer, selected]
    } else {
      dropdownShow = null
      //  dropdown.style.zIndex = ''; // 取消置前效果
    }

    // 切换箭头方向和选中状态
    selected.classList.toggle('下拉-箭头-up', !isOpen);
    selected.classList.toggle('下拉-箭头-down', isOpen);
    selected.classList.toggle('下拉-active', !isOpen);

  });
  window.addEventListener('scroll', function () {
    dropdownShow = null
    itemsContainer.style.display = 'none';
    selected.classList.add('下拉-箭头-down');
    selected.classList.remove('下拉-箭头-up');
    selected.classList.remove('下拉-active');
  })

  // 点击外部区域时关闭下拉框
  window.addEventListener('click', function () {
    dropdownShow = null
    itemsContainer.style.display = 'none';
    selected.classList.add('下拉-箭头-down');
    selected.classList.remove('下拉-箭头-up');
    selected.classList.remove('下拉-active');
    //dropdown.style.zIndex = ''; // 取消置前效果
  });
  joinList(id, '下拉列表')
}


function 创建图像(id, src, parent) {
  var img = document.createElement('img')
  img.id = id
  img.src = src
  if (parent) {
    let uiparent = document.getElementById(parent)
    uiparent.appendChild(img)
  } else {
    document.body.appendChild(img)
  }
  joinList(id, '图像')
}

function 添加列表选项(text, parent) {
  var select = document.getElementById(parent)
  var option = document.createElement('div')
  option.innerHTML = text
  option.addEventListener('click', function () {
    document.querySelectorAll(`#${parent} .selected`).forEach(item => item.classList.remove('selected'))
    this.classList.add('selected')
    document.getElementById(parent).dataset.value = text
    document.getElementById(parent).dataset.index = Array.from(document.getElementById(parent).children).indexOf(this)
    if (eventList[parent] != null) {
      eventList[parent]();
    }
  })
  select.appendChild(option)
}

function 设置列表选中项(setOption, parent) {
  if (document.getElementById(parent).classList.contains('下拉-下拉')) {
    let dropdown = document.getElementById(parent)
    let selected = dropdown.firstElementChild
    let options = dropdown.lastElementChild
    let optionIndex = -1
    let option = options.querySelectorAll("div")
    option.forEach((item, index) => {
      if (item.innerHTML == setOption) {
        optionIndex = index
      }
    })
    if (optionIndex < 0) {
      console.error('无法找到选项:' + setOption)
    } else {
      selected.dataset.value = setOption
      selected.dataset.index = optionIndex
      selected.firstElementChild.innerHTML = setOption;
      option.forEach((item, index) => {
        if (index == optionIndex) {
          item.classList.add('same-as-selected')
        } else {
          item.classList.remove('same-as-selected')
        }
      })
    }
  } else {
    let div = document.querySelector('#' + parent);
    div.dataset.value = setOption
    div.querySelectorAll('div').forEach((item, index) => {
      if (item.innerHTML == setOption) {
        item.classList.add('selected')
        div.dataset.index = index
      } else {
        item.classList.remove('selected')
      }
    })
  }
}

function 设置类名(id, className) {
  document.getElementById(id).className = className
}

function 添加类名(id, className) {
  document.getElementById(id).classList.add(className)
}
function 移除类名(id, className) {
  document.getElementById(id).classList.remove(className)
}

function 设置高度(id, height) {
  if (isNumeric(height)) {
    if (document.getElementById(id).classList.contains('transfer-container')) {
      document.getElementById(id).querySelectorAll('.list-box').forEach(item => item.style.height = height + 'px')
      document.getElementById(id).querySelectorAll('.list-content').forEach(item => item.style.height = height - 60 + 'px')
      document.getElementById(id).querySelector('.buttons').style.height = height + 'px'
    } else {
      document.getElementById(id).style.height = height + 'px'
    }
  } else {
    if (document.getElementById(id).classList.contains('transfer-container')) {
      height = height.replace('px', '')
      document.getElementById(id).querySelectorAll('.list-box').forEach(item => item.style.height = height + 'px')
      document.getElementById(id).querySelectorAll('.list-content').forEach(item => item.style.height = height - 60 + 'px')
      document.getElementById(id).querySelector('.buttons').style.height = height + 'px'
    } else {
      document.getElementById(id).style.height = height
    }
  }
}
function 设置宽度(id, width) {
  if (isNumeric(width)) {
    document.getElementById(id).style.width = width + 'px'
  } else {
    document.getElementById(id).style.width = width
  }
}

function isNumeric(str) {
  return /^\d+$/.test(str);
}

function 设置背景色(id, color) {
  document.getElementById(id).style.backgroundColor = color
}
function 设置字体颜色(id, color) {
  document.getElementById(id).style.color = color
}

function 设置字体大小(id, size) {
  if (isNumeric(size)) {
    document.getElementById(id).style.fontSize = size + 'px'
  } else {
    document.getElementById(id).style.fontSize = size
  }
}
function 设置字体粗细(id, weight) {
  document.getElementById(id).style.fontWeight = weight
}
function 设置文本对齐方式(id, align) {
  if (align == '中') {
    document.getElementById(id).style.textAlign = 'center'
  } else if (align == '左') {
    document.getElementById(id).style.textAlign = 'left'
  } else if (align == '右') {
    document.getElementById(id).style.textAlign = 'right'
  } else if (align == '垂直中') {
    document.getElementById(id).style.display = "flex"
    document.getElementById(id).style.justifyContent = "center"
    document.getElementById(id).style.alignItems = "center"
  }
}

function 设置边框粗细(id, size) {
  if (isNumeric(size)) {
    document.getElementById(id).style.borderWidth = size + 'px'
  } else {
    document.getElementById(id).style.borderWidth = size
  }
}

function 设置边框圆角(id, size) {
  if (isNumeric(size)) {
    document.getElementById(id).style.borderRadius = size + 'px'
  } else {
    document.getElementById(id).style.borderRadius = size
  }
}
function 设置边框样式(id, style) {
  if (style == '实线') {
    document.getElementById(id).style.borderStyle = 'solid'
  } else if (style == '虚线') {
    document.getElementById(id).style.borderStyle = 'dashed'
  }
  else if (style == '点线') {
    document.getElementById(id).style.borderStyle = 'dotted'
  } else if (style == '隐藏') {
    document.getElementById(id).style.borderStyle = 'none'
  }


}

function 设置边框颜色(id, color) {
  document.getElementById(id).style.borderColor = color
}

function 设置内边距(id, top, right, bottom, left) {
  if (left == undefined) {
    left = 0
  }

  if (bottom != undefined) {
    document.getElementById(id).style.padding = top + 'px ' + right + 'px ' + bottom + 'px ' + left + 'px'
  } else if (right != undefined) {
    document.getElementById(id).style.padding = top + 'px ' + right + 'px'
  }
  else if (top != undefined) {
    document.getElementById(id).style.padding = top + 'px'
  }



}
function 设置外边距(id, top, right, bottom, left) {
  if (left == undefined) {
    left = 0
  }
  if (bottom != undefined) {
    document.getElementById(id).style.margin = top + 'px ' + right + 'px ' + bottom + 'px ' + left + 'px'
  } else if (right != undefined) {
    document.getElementById(id).style.margin = top + 'px ' + right + 'px'
  }
  else if (top != undefined) {
    document.getElementById(id).style.margin = top + 'px'
  }
}

function 设置堆叠顺序(id, order) {
  document.getElementById(id).style.zIndex = order
}

function 设置悬浮(id, Horizontal, Vertical, x, y) {
  var element = document.getElementById(id)
  element.style.position = 'fixed'
  let transformX = '0'
  let transformY = '0'
  // 设置水平停靠样式
  if (Horizontal === '左') {
    element.style.left = x + 'px'
  } else if (Horizontal === '中') {
    // 设置居中
    element.style.left = '50%'
    transformX = '-50%'
  } else if (Horizontal === '右') {
    // 设置右侧
    element.style.right = x + 'px'
  }

  if (Vertical === '上') {
    element.style.top = y + 'px'
  } else if (Vertical === '中') {
    // 设置顶部固定
    element.style.top = '50%'
    element.style.marginTop = y + 'px'
    transformY = '-50%'
  } else if (Vertical === '下') {
    // 设置底部固定
    element.style.bottom = '0'
    element.style.marginBottom = y + 'px'
  }
  element.style.transform = `translate(${transformX},${transformY})`
}

function 设置显示(id, display) {
  if (display == '显示') {
    document.getElementById(id).style.display = 'block'
  } else if (display == '隐藏') {
    document.getElementById(id).style.display = 'none'
  }

}

function 点击事件(id, func) {
  document.getElementById(id).onclick = func
}

function 按下事件(id, func) {
  document.getElementById(id).onmousedown = func
}

function 抬起事件(id, func) {
  document.getElementById(id).onmouseup = func
}

function 选择行改变事件(id, func) {
  eventList[id] = func
}

function 聚焦事件(id, func) {
  document.getElementById(id).onfocus = func
}

function 失焦事件(id, func) {
  document.getElementById(id).onblur = func
}

function 文本变更事件(id, func) {
  document.getElementById(id).oninput = func
}

/**
   * 为按钮添加雪花效果
   * @param {string} buttonId - 按钮ID
   * @param {number} numberOfSnowflakes - 雪花数量
   */
function 下雪花(buttonId, numberOfSnowflakes = 100) {
  const button = document.getElementById(buttonId);
  if (!button) {
    console.error('未找到按钮：', buttonId);
    return;
  }

  for (let i = 0; i < numberOfSnowflakes; i++) {
    const snowflake = document.createElement('div');
    snowflake.className = 'button-snowflake yjwEffect';
    //设置下雪花的高度是控件的高度
    document.documentElement.style.setProperty('--translate-distance', (button.offsetHeight + 20) + 'px');
    // 随机生成水平和垂直动画
    const duration = Math.random() * 2 + 1 + 's';//时间
    const horizontalMovement = (Math.random() - 0.5) * 60;//最大水平运动
    const verticalMovement = 20;//最大垂直运动
    const size = Math.random() * 3 + 1;//雪花大小
    snowflake.style.width = snowflake.style.height = size + 'px';
    snowflake.style.left = Math.random() * (button.offsetWidth - size - 20) + button.offsetLeft + 'px';
    snowflake.style.top = button.offsetTop - verticalMovement + "px";


    snowflake.style.animation = `buttonFall ${duration} linear infinite`;
    snowflake.style.transform = `translate(${horizontalMovement}px, ${verticalMovement}px)`;
    snowflake.style.animationDuration = duration;

    button.appendChild(snowflake);
  }
}

function 删除特效(id) {
  const button = document.getElementById(id);
  if (!button) {
    console.error('未找到按钮：', id);
    return;
  }
  button.querySelectorAll('.yjwEffect').forEach(snowflake => snowflake.remove());
}

function 跳转锚点(id, shu) {
  const target = document.getElementById(id);
  if (target) {
    // 获取控件在文档中的垂直位置
    const targetPosition = target.getBoundingClientRect().top + window.pageYOffset + Number(shu);

    // 滚动到控件
    window.scrollTo({
      top: targetPosition,
      behavior: 'smooth' // 平滑滚动
    });
  }
}

function 创建菜单(buttonNames, containerId, top) {
  const container = document.getElementById(containerId);
  if (!container) {
    console.error('未找到容器：', containerId);
    return;
  }
  // 清空容器内容
  container.innerHTML = '';
  let div = document.createElement('div');
  div.style.display = 'flex';
  div.style.overflowX = 'auto';
  div.style.whiteSpace = 'nowrap';
  div.style.width = '100%';
  // 遍历按钮名称数组，创建按钮元素并添加到容器
  buttonNames.forEach(name => {
    const button = document.createElement('菜单-button');
    button.style.width = '100%';
    button.style.textAlign = 'center';
    button.className = '菜单-button'; // 添加按钮样式
    button.innerHTML = name; // 设置按钮文本
    // 根据按钮文本设置不同的事件处理
    button.onclick = function () {
      跳转锚点(name, Number(top))
    };
    div.appendChild(button); // 将按钮添加到容器中
  });
  container.appendChild(div); // 将容器添加到页面中
  scrollHightlight()
  window.addEventListener('scroll', () => {
    scrollHightlight(buttonNames)
  });

}

function scrollHightlight(buttonNames) {
  // 当前滚动的距离
  var current = document.documentElement.scrollTop || document.body.scrollTop;
  // 页面的总高度
  var offsetHeight = document.documentElement.offsetHeight;
  // 页面的可视高度
  var clientHeight = document.documentElement.clientHeight;
  //滚动条可活动的总高度
  var activeHeight = offsetHeight - clientHeight;
  // 当前滚动的距离为0时
  if (current === 0) {
    var links = document.querySelectorAll('菜单-button');
    for (var i = 0; i < links.length; i++) {
      links[i].classList.remove('菜单-active');
    }
    if (links.length > 0) {
      links[0].classList.add('菜单-active');
    }
  } else if (current === activeHeight) {
    var links = document.querySelectorAll('菜单-button');
    for (var i = 0; i < links.length; i++) {
      links[i].classList.remove('菜单-active');
    }
    if (links.length > 0) {
      links[links.length - 1].classList.add('菜单-active');
    }

  } else {
    let divs = []
    buttonNames.forEach(name => {
      const target = document.getElementById(name);
      if (target) {
        divs.push(target)
      }
    })
    let min = offsetHeight
    let index = 0
    for (let i = 0; i < divs.length; i++) {
      let divTop = Math.abs(divs[i].getBoundingClientRect().top + window.pageYOffset - current)
      if (divTop < min) {
        min = divTop
        index = i
      }
    }
    var links = document.querySelectorAll('菜单-button');
    for (let i = 0; i < links.length; i++) {
      if (i === index) {
        links[i].classList.add('菜单-active');
      } else {
        links[i].classList.remove('菜单-active');
      }
    }

  }
}

function 创建穿梭框(id, sourceName, targetName, parentId) {
  // 创建穿梭框的HTML结构
  const transferContainer = document.createElement("div");
  transferContainer.className = "transfer-container";
  transferContainer.id = id;

  const sourceList = document.createElement("div");
  sourceList.className = "list-box";
  sourceList.id = id + "sourceList";

  const sourceHeader = document.createElement("header");
  const sourceSelectAll = document.createElement("input");
  sourceSelectAll.type = "checkbox";
  sourceSelectAll.id = id + "selectAllSource";
  sourceSelectAll.onclick = function () {
    toggleSelectAll(this, id + "sourceList", id);
  };

  const sourceTitle = document.createElement("span");
  sourceTitle.innerHTML = sourceName;
  sourceTitle.style.margin = "0";
  sourceTitle.style.padding = "0 5px";

  const sourceCount = document.createElement("span");
  sourceCount.id = id + "sourceCount";
  sourceCount.style.marginLeft = "auto";
  sourceCount.innerHTML = "0";
  sourceHeader.appendChild(sourceSelectAll);
  sourceHeader.appendChild(sourceTitle);
  sourceHeader.appendChild(sourceCount);
  sourceList.appendChild(sourceHeader);

  const sourceContent = document.createElement("div");
  sourceContent.className = "list-content";
  sourceList.appendChild(sourceContent);

  const buttons = document.createElement("div");
  buttons.className = "buttons";

  const toRightButton = document.createElement("button");
  toRightButton.id = id + "toRight";
  toRightButton.innerHTML = ">";
  toRightButton.onclick = function () {
    moveItems(id + "sourceList", id + "targetList", id);
  };
  buttons.appendChild(toRightButton);

  const toLeftButton = document.createElement("button");
  toLeftButton.id = id + "toLeft";
  toLeftButton.innerHTML = "<";
  toLeftButton.onclick = function () {
    moveItems(id + "targetList", id + "sourceList", id);
  };
  buttons.appendChild(toLeftButton);

  transferContainer.appendChild(sourceList);
  transferContainer.appendChild(buttons);

  const targetList = document.createElement("div");
  targetList.className = "list-box";
  targetList.id = id + "targetList";

  const targetHeader = document.createElement("header");
  const targetSelectAll = document.createElement("input");
  targetSelectAll.type = "checkbox";
  targetSelectAll.id = id + "selectAllTarget";
  targetSelectAll.onclick = function () {
    toggleSelectAll(this, id + "targetList", id);
  };

  const targetTitle = document.createElement("span");
  targetTitle.innerHTML = targetName;
  targetTitle.style.margin = "0";
  targetTitle.style.padding = "0 5px";

  const targetCount = document.createElement("span");
  targetCount.id = id + "targetCount";
  targetCount.style.marginLeft = "auto";
  targetCount.innerHTML = "0";
  targetHeader.appendChild(targetSelectAll);
  targetHeader.appendChild(targetTitle);
  targetHeader.appendChild(targetCount);
  targetList.appendChild(targetHeader);

  const targetContent = document.createElement("div");
  targetContent.className = "list-content";
  targetList.appendChild(targetContent);

  transferContainer.appendChild(targetList);

  // 将穿梭框添加到父容器中
  if (parentId) {
    let uiparent = document.getElementById(parentId);
    uiparent.appendChild(transferContainer);
  } else {
    document.body.appendChild(transferContainer);
  }
  joinList(id, '穿梭框')
}
function 添加源列表(id, List) {
  let list1 = 获取穿梭框源列表(id);
  document.getElementById(id + "sourceList").querySelector(".list-content").innerHTML = "";
  List = list1.concat(List);
  for (let i = 0; i < List.length; i++) {
    const item = document.createElement("div");
    item.className = "list-item";
    const checkbox = document.createElement("input");
    checkbox.type = "checkbox";
    checkbox.id = id + "sourceCheckbox" + i;
    checkbox.onchange = function () {
      checkSelections(id); // 更新按钮状态
    };
    item.appendChild(checkbox);
    const label = document.createElement("label");
    label.style.display = "flex";
    label.style.alignItems = "center";
    label.innerHTML = List[i];
    label.setAttribute("for", id + "sourceCheckbox" + i);
    item.appendChild(label);
    document
      .getElementById(id + "sourceList")
      .querySelector(".list-content")
      .appendChild(item);
  }
  updateCounts(id);
  checkSelections(id);
  updateInputId(id);
}
function 添加目标列表(id, List) {
  let list1 = 获取穿梭框目标列表(id);
  document.getElementById(id + "targetList").querySelector(".list-content").innerHTML = "";
  List = list1.concat(List);
  for (let i = 0; i < List.length; i++) {
    const item = document.createElement("div");
    item.className = "list-item";
    const checkbox = document.createElement("input");
    checkbox.type = "checkbox";
    checkbox.id = id + "targetCheckbox" + i;
    checkbox.onchange = function () {
      checkSelections(id); // 更新按钮状态
    };
    item.appendChild(checkbox);
    const label = document.createElement("label");
    label.style.display = "flex";
    label.style.alignItems = "center";
    label.innerHTML = List[i];
    label.setAttribute("for", id + "targetCheckbox" + i);
    item.appendChild(label);
    document
      .getElementById(id + "targetList")
      .querySelector(".list-content")
      .appendChild(item);
  }
  updateCounts(id);
  checkSelections(id);
  updateInputId(id);
}

function 设置目标列表(id, List) {
  document.getElementById(id + "targetList").querySelector(".list-content").innerHTML = "";
  for (let i = 0; i < List.length; i++) {
    const item = document.createElement("div");
    item.className = "list-item";
    const checkbox = document.createElement("input");
    checkbox.type = "checkbox";
    checkbox.id = id + "targetCheckbox" + i;
    checkbox.onchange = function () {
      checkSelections(id); // 更新按钮状态
    };
    item.appendChild(checkbox);
    const label = document.createElement("label");
    label.style.display = "flex";
    label.style.alignItems = "center";
    label.innerHTML = List[i];
    label.setAttribute("for", id + "targetCheckbox" + i);
    item.appendChild(label);
    document
      .getElementById(id + "targetList")
      .querySelector(".list-content")
      .appendChild(item);
  }
  updateCounts(id);
  checkSelections(id);
  updateInputId(id);
}

function 设置源列表(id, List) {
  document.getElementById(id + "sourceList").querySelector(".list-content").innerHTML = "";
  for (let i = 0; i < List.length; i++) {
    const item = document.createElement("div");
    item.className = "list-item";
    const checkbox = document.createElement("input");
    checkbox.type = "checkbox";
    checkbox.id = id + "sourceCheckbox" + i;
    checkbox.onchange = function () {
      checkSelections(id); // 更新按钮状态
    };
    item.appendChild(checkbox);
    const label = document.createElement("label");
    label.style.display = "flex";
    label.style.alignItems = "center";
    label.innerHTML = List[i];
    label.setAttribute("for", id + "sourceCheckbox" + i);
    item.appendChild(label);
    document
      .getElementById(id + "sourceList")
      .querySelector(".list-content")
      .appendChild(item);
  }
  updateCounts(id);
  checkSelections(id);
  updateInputId(id);
}

function 获取穿梭框源列表(id) {
  const sourceList = document.getElementById(id + "sourceList");
  const content = sourceList.querySelector(".list-content");
  const checkboxes = content.querySelectorAll('input[type="checkbox"]');
  const selectedItems = [];
  checkboxes.forEach((checkbox) => {
    selectedItems.push(checkbox.nextElementSibling.innerHTML);
  });
  return selectedItems;
}
function 获取穿梭框目标列表(id) {
  const targetList = document.getElementById(id + "targetList");
  const content = targetList.querySelector(".list-content");
  const checkboxes = content.querySelectorAll('input[type="checkbox"]');
  const selectedItems = [];
  checkboxes.forEach((checkbox) => {
    selectedItems.push(checkbox.nextElementSibling.innerHTML);
  });
  return selectedItems;
}

function moveItems(from, to, id) {
  // 获取源列表并筛选已选中的复选框项目
  const fromList = document.getElementById(from).querySelector(".list-content");
  const checkboxes = fromList.querySelectorAll('input[type="checkbox"]:checked');

  checkboxes.forEach((checkbox) => {
    const item = checkbox.parentElement;
    fromList.removeChild(item);
    document.getElementById(to).querySelector(".list-content").appendChild(item);
  });

  checkSelections(id); // 空项检查及按钮状态更新
  updateCounts(id); // 更新计数显示
}

function toggleSelectAll(selectAllCheckbox, listId, id) {
  // 切换全选复选框状态，并设置每个项目的选中状态
  const list = document.getElementById(listId);
  const checkboxes = list.querySelectorAll('.list-content input[type="checkbox"]');
  checkboxes.forEach((checkbox) => {
    checkbox.checked = selectAllCheckbox.checked;
  });

  checkSelections(id);
}

function checkSelections(id) {
  // 检查源和目标列表中是否有选中的项，并调整按钮启用状态

  const sourceChecked = document.querySelectorAll(`#${id}sourceList .list-content input[type="checkbox"]:checked`).length > 0;
  const targetChecked = document.querySelectorAll(`#${id}targetList .list-content input[type="checkbox"]:checked`).length > 0;

  const toRightButton = document.getElementById(id + "toRight");
  const toLeftButton = document.getElementById(id + "toLeft");

  // 根据有无选中的项启用或禁用按钮
  if (sourceChecked) {
    toRightButton.classList.add("enabled");
    toRightButton.disabled = false;
  } else {
    toRightButton.classList.remove("enabled");
    toRightButton.disabled = true;
  }

  if (targetChecked) {
    toLeftButton.classList.add("enabled");
    toLeftButton.disabled = false;
  } else {
    toLeftButton.classList.remove("enabled");
    toLeftButton.disabled = true;
  }
}
// 添加列表后更新所有的选择框id
function updateInputId(id) {
  const checkboxes = document.querySelectorAll(`#${id}sourceList .list-content input[type="checkbox"]`);
  checkboxes.forEach((checkbox, index) => {
    checkbox.id = `${id}sourceCheckbox${index}`;
    checkbox.nextElementSibling.setAttribute("for", `${id}sourceCheckbox${index}`);
  });

  const targetCheckboxes = document.querySelectorAll(`#${id}targetList .list-content input[type="checkbox"]`);
  targetCheckboxes.forEach((checkbox, index) => {
    checkbox.id = `${id}targetCheckbox${index}`;
    checkbox.nextElementSibling.setAttribute("for", `${id}targetCheckbox${index}`);
  });
}

function updateCounts(id) {
  // 更新显示的项目数量
  const sourceCount = document.querySelectorAll(`#${id}sourceList .list-content div`).length;
  const targetCount = document.querySelectorAll(`#${id}targetList .list-content div`).length;

  document.getElementById(id + "sourceCount").innerHTML = sourceCount;
  document.getElementById(id + "targetCount").innerHTML = targetCount;
}


window.onerror = function (message, source, lineno, colno, error) {
  let message1 = {
    funName: "errorMessage",
    funParam: {
      message: message,
      source: source,
      lineno: lineno,
      colno: colno,
    }
  };
  message1 = JSON.stringify(message1);
  sendMessageToParent(message1);
};

function sendMessageToParent(message) {
  window.parent.postMessage(message, '*');
}