
let creatTree = [
  {
    label: "创建水平布局",
    kind: 27,
    detail: "创建水平布局('ID' ,'父ID')  // 父ID为空时,添加至主窗体",
    insertText: "创建水平布局('${1}','${2}')",

  },
  {
    label: "创建垂直布局",
    kind: 27,
    detail: "创建垂直布局('ID' ,'父ID')  // 父ID为空时,添加至主窗体",
    insertText: "创建垂直布局('${1}','${2}')",

  }, {
    label: "创建按钮",
    kind: 27,
    detail: "创建按钮('ID', '按钮文本', '父ID(可为空)')",
    insertText: "创建按钮('${1}','${2}','${3}')",

  },
  {
    label: "创建标签",
    kind: 27,
    detail: "创建标签('ID', '标签文本', '父ID(可为空)')",
    insertText: "创建标签('${1}','${2}','${3}')",

  },
  {
    label: "创建单选框",
    kind: 27,
    detail: "创建单选框('ID', '单选框文本', '单选框组', '父ID(可为空)')  //单选框选项ID为:ID_选项,如:单选框1_选项",
    insertText: "创建单选框('${1}','${2}','${3}','${4}')",

  },
  {
    label: "创建复选框",
    kind: 27,
    detail: "创建复选框('ID', '复选框文本', '父ID(可为空)')  //复选框选项ID为:ID_选项,如:复选框1_选项",
    insertText: "创建复选框('${1}','${2}','${3}')",

  },
  {
    label: "创建文本框",
    kind: 27,
    detail: "创建文本框('ID','提示信息', '父ID(可为空)')",
    insertText: "创建文本框('${1}','${2}','${3}')",

  },
  {
    label: "创建多行文本框",
    kind: 27,
    detail: "创建多行文本框('ID','不可拖动/可拖动', '父ID(可为空)') //不可拖动/可拖动 默认为可拖动",
    insertText: "创建多行文本框('${1}','${2}')",

  },
  {
    label: "创建列表框",
    kind: 27,
    detail: "创建列表框('ID', '父ID(可为空)')",
    insertText: "创建列表框('${1}','${2}')",

  },
  {
    label: "创建下拉列表",
    kind: 27,
    detail: "创建下拉列表('ID', '父ID(可为空)' , 列表选项数组) // 例 ['选项1', '选项2', '选项3']",
    insertText: "创建下拉列表('${1}','${2}' , [${3}])",

  }, {
    label: "创建图像",
    kind: 27,
    detail: "创建图像('ID', '图像路径', '父ID(可为空)')",
    insertText: "创建图像('${1}','${2}','${3}')",

  }, {
    label: "创建菜单",
    kind: 27,
    detail: "创建菜单([按钮名称数组], 所属控件ID,跳转偏移量) //点击菜单按钮会跳转至同名的控件位置",
    insertText: "创建菜单([${1}],${2},${3})",
  }, {
    label: "创建穿梭框",
    kind: 27,
    detail: "创建穿梭框('控件ID','源列表名','目标列表名', '所属控件ID') ",
    insertText: "创建穿梭框('${1}','${2}','${3}','${4}')",
  },
]

let setTree = [
  {
    label: "添加源列表",
    kind: 27,
    detail: "添加源列表('穿梭框ID', [选项数组]) ",
    insertText: "添加源列表('${1}',[${2}])",
  }, {
    label: "添加目标列表",
    kind: 27,
    detail: "添加目标列表('穿梭框ID', [选项数组]) ",
    insertText: "添加目标列表('${1}',[${2}])",
  },
  {
    label: "设置源列表",
    kind: 27,
    detail: "设置源列表('穿梭框ID', [选项数组]) ",
    insertText: "设置源列表('${1}',[${2}])",
  }, {
    label: "设置目标列表",
    kind: 27,
    detail: "设置目标列表('穿梭框ID', [选项数组]) ",
    insertText: "设置目标列表('${1}',[${2}])",
  },
  {
    label: "设置控件值",
    kind: 27,
    detail: "设置控件值('json')  // 传入格式与获取控件列表的返回值的格式相同 单选框与复选框格式为{'控件ID':{选择状态:true/false}} 文本框格式为{'控件ID':{'输入文本':'文本内容'}}  列表框格式为{'控件ID':{'选择行/选择文本':'0/选项1'}}",
    insertText: "设置控件值('${1}')",
  },
  {
    label: "添加列表选项",
    kind: 27,
    detail: "添加列表选项('选项文本', '所属列表框ID') // 仅能添加列表框选项",
    insertText: "添加列表选项('${1}','${2}')",

  },
  {
    label: "设置列表选中项",
    kind: 27,
    detail: "设置列表选中项('选项名', '所属列表框ID')",
    insertText: "设置列表选中项('${1}','${2}')",
  },
  {
    label: "设置类名",
    kind: 27,
    detail: "设置类名('控件ID', '类名')",
    insertText: "设置类名('${1}','${2}')",

  }, {
    label: "添加类名",
    kind: 27,
    detail: "添加类名('控件ID', '类名')",
    insertText: "添加类名('${1}','${2}')",

  },
  {
    label: "移除类名",
    kind: 27,
    detail: "移除类名('控件ID', '类名')",
    insertText: "移除类名('${1}','${2}')",
  },
  {
    label: "设置布局排列",
    kind: 27,
    detail: "设置布局排列('布局ID', '居中/靠左/靠右/两端/环绕/平均')",
    insertText: "设置布局排列('${1}','${2}')",

  },
  {
    label: "设置布局垂直排列",
    kind: 27,
    detail: "设置布局垂直排列('布局ID', '居中/靠上/靠下/基线/拉伸')",
    insertText: "设置布局垂直排列('${1}','${2}')",

  },
  {
    label: "设置高度",
    kind: 27,
    detail: "设置高度('控件ID', 20)",
    insertText: "设置高度('${1}',${2})",

  },
  {
    label: "设置宽度",
    kind: 27,
    detail: "设置宽度('控件ID', 20)",
    insertText: "设置宽度('${1}',${2})",

  },
  {
    label: "设置背景色",
    kind: 27,
    detail: "设置背景色('控件ID', '颜色值')",
    insertText: "设置背景色('${1}','${2}')",

  },
  {
    label: "设置字体颜色",
    kind: 27,
    detail: "设置字体颜色('控件ID', '颜色值')",
    insertText: "设置字体颜色('${1}','${2}')",

  },
  {
    label: "设置字体大小",
    kind: 27,
    detail: "设置字体大小('控件ID', 20)",
    insertText: "设置字体大小('${1}',${2})",

  },
  {
    label: "设置字体粗细",
    kind: 27,
    detail: "设置字体粗细('控件ID', 700) //介于1和1000之间 字体默认粗细为 400 加粗通常为700",
    insertText: "设置字体粗细('${1}',${2})",
  },
  {
    label: "设置文本对齐方式",
    kind: 27,
    detail: "设置文本对齐方式('控件ID', '中/左/右/垂直中')",
    insertText: "设置文本对齐方式('${1}','${2}')",

  },
  {
    label: "设置边框样式",
    kind: 27,
    detail: "设置边框样式('控件ID', '实线/虚线/点线/隐藏')",
    insertText: "设置边框样式('${1}','${2}')",

  },
  {
    label: "设置边框粗细",
    kind: 27,
    detail: "设置边框粗细('控件ID', 2)",
    insertText: "设置边框粗细('${1}',${2})",

  },
  {
    label: "设置边框圆角",
    kind: 27,
    detail: "设置边框圆角('控件ID', 10)",
    insertText: "设置边框圆角('${1}',${2})",

  },
  {
    label: "设置边框颜色",
    kind: 27,
    detail: "设置边框颜色('控件ID', '颜色值')",
    insertText: "设置边框颜色('${1}','${2}')",

  },
  {
    label: "设置内边距",
    kind: 27,
    detail: "设置内边距('控件ID', 10, 10, 10, 10) //上/右/下/左",
    insertText: "设置内边距('${1}',${2},${3},${4},${5})",

  },
  {
    label: "设置外边距",
    kind: 27,
    detail: "设置外边距('控件ID', 10, 10, 10, 10) //上/右/下/左",
    insertText: "设置外边距('${1}',${2},${3},${4},${5})",

  },
  {
    label: "设置悬浮",
    kind: 27,
    detail: "设置悬浮('控件ID', '水平位置', '垂直位置', 10, 10)  //水平位置:左/中/右,垂直位置:上/中/下",
    insertText: "设置悬浮('${1}','${2}','${3}',${4},${5}))'",

  }, {
    label: "设置堆叠顺序",
    kind: 27,
    detail: "设置堆叠顺序('控件ID', 10)  //默认值为0 取值越大，定位元素在层叠元素上越靠上。",
    insertText: "设置堆叠顺序('${1}',${2})'",

  },
  {
    label: "设置显示",
    kind: 27,
    detail: "设置显示('控件ID' ,'显示/隐藏')",
    insertText: "设置显示('${1}','${2}')",
  }, {
    label: "跳转锚点",
    kind: 27,
    detail: "跳转锚点('控件ID', 偏移量) //跳转到指定控件位置",
    insertText: "跳转锚点('${1}',${2})",
  }
]

let getTree = [
  {
    label: "获取单选框值",
    kind: 27,
    detail: "获取单选框值('id') //返回true/false",
    insertText: "获取单选框值('${1}')",
  },
  {
    label: "获取单选框组选中ID",
    kind: 27,
    detail: "获取单选框组选中ID('name') //返回选中单选框的id",
    insertText: "获取单选框组选中ID('${1}')",
  },
  {
    label: "获取复选框值",
    kind: 27,
    detail: "获取复选框值('id') //返回true/false",
    insertText: "获取复选框值('${1}')",
  },
  {
    label: "获取下拉框选择文本",
    kind: 27,
    detail: "获取下拉框选择文本('id') //返回选中下拉框的文本",
    insertText: "获取下拉框选择文本('${1}')",
  },
  {
    label: "获取下拉框选择行",
    kind: 27,
    detail: "获取下拉框选择行('id') //返回选中下拉框的行",
    insertText: "获取下拉框选择行('${1}')",
  },
  {
    label: "获取列表框选择文本",
    kind: 27,
    detail: "获取列表框选择文本('id') //返回选中列表框的文本",
    insertText: "获取列表框选择文本('${1}')",
  },
  {
    label: "获取列表框选择行",
    kind: 27,
    detail: "获取列表框选择行('id') //返回选中列表框的行",
    insertText: "获取列表框选择行('${1}')",
  },
  {
    label: "获取文本框文本",
    kind: 27,
    detail: "获取文本框文本('id') //返回文本框文本",
    insertText: "获取文本框文本('${1}')",
  },
  {
    label: "获取控件列表",
    kind: 27,
    detail: "获取控件列表(state)  // 1=所有单选和复选框,2=所有文本框,4=所有列表和下拉列表,8=穿梭框源列表和目标列表 15=以上全部(可省略) 返回值为字符串",
    insertText: "获取控件列表(${1})",

  }, {
    label: "获取穿梭框源列表",
    kind: 27,
    detail: "获取穿梭框源列表('穿梭框ID') //返回源列表选项数组 ",
    insertText: "获取穿梭框源列表('${1}')",
  }, {
    label: "获取穿梭框目标列表",
    kind: 27,
    detail: "获取穿梭框目标列表('穿梭框ID') //返回目标列表选项数组  ",
    insertText: "获取穿梭框目标列表('${1}')",
  }
]
let eventTree = [
  {
    label: "点击事件",
    kind: 27,
    detail: "点击事件('控件ID', 函数名)",
    insertText: "点击事件('${1}',${2})",

  },
  {
    label: "按下事件",
    kind: 27,
    detail: "按下事件('控件ID', 函数名)",
    insertText: "按下事件('${1}',${2})",

  },
  {
    label: "抬起事件",
    kind: 27,
    detail: "抬起事件('控件ID', 函数名)",
    insertText: "抬起事件('${1}',${2})",

  },
  {
    label: "选择行改变事件",
    kind: 27,
    detail: "选择行改变事件('下拉框或选择框ID', 函数名)",
    insertText: "选择行改变事件('${1}',${2})",

  },
  {
    label: "聚焦事件",
    kind: 27,
    detail: "聚焦事件('控件ID', 函数名)",
    insertText: "聚焦事件('${1}',${2})",

  },
  {
    label: "失焦事件",
    kind: 27,
    detail: "失焦事件('控件ID', 函数名)",
    insertText: "失焦事件('${1}',${2})",
  },
  {
    label: "文本变更事件",
    kind: 27,
    detail: "文本变更事件('控件ID', 函数名)",
    insertText: "文本变更事件('${1}',${2})",
  },
]
let effectsTree = [

  {
    label: "特效-下雪花",
    kind: 27,
    detail: "下雪花('控件ID', 雪花数量)",
    insertText: "下雪花('${1}',${2})",
  },
  {
    label: "删除特效",
    kind: 27,
    detail: "删除特效('控件ID')",
    insertText: "删除特效('${1}')",
  },
]
let luafunctions = [
  {
    label: "调用Lua函数",
    kind: 27,
    detail: `JsCallJava.CallLua("JS传递到Lua的参数");`,
    insertText: `JsCallJava.CallLua("JS传递到Lua的参数");`,
  }
]

let suggestions = [...creatTree, ...setTree, ...getTree, ...eventTree, ...effectsTree, ...luafunctions]
let register = function () {
  suggestions.forEach((node) => {
    node.insertTextRules = monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet
  });
  monaco.languages.registerHoverProvider("html", {
    provideHover: function (model, position, token) {
      const word = model.getWordAtPosition(position)?.word;
      let help = suggestions.filter((item) => item.label === word);
      if (help.length > 0) {
        return {
          contents: [
            {
              supportHtml: true,
              value: help[0].detail.replace(/\r/g, "\r\r")
            }
          ]
        };
      }
    }
  });

  monaco.languages.registerCompletionItemProvider("*", {
    provideCompletionItems: () => {
      return {
        suggestions: suggestions
      };
    },
  });

};
