let register = function () {
  // Method = 0 方法 
  // Function = 1, 函数 
  // Constructor = 2,构造函数
  // Field = 3,字段
  // Variable = 4,变量
  // Class = 5,类
  // Struct = 6,结构体
  // Interface = 7,接口 
  // Module = 8,模块
  // Property = 9,属性
  // Event = 10, 事件
  // Operator = 11,运算符
  // Unit = 12,单元
  // Value = 13, 值
  // Constant = 14,常量
  // Enum = 15,枚举
  // EnumMember = 16,枚举成员
  // Keyword = 17,关键字
  // Text = 18,文本
  // Color = 19, 颜色
  // File = 20,文件
  // Reference = 21, 引用
  // Customcolor = 22, 自定义颜色
  // Folder = 23,文件夹
  // TypeParameter = 24,类型参数 
  // User = 25,用户
  // Issue = 26,问题
  // Snippet = 27代码片段

  // monaco.languages.registerHoverProvider('lua', { // 光标移入提示功能
  //   provideHover: function (model, position, token) {
  //     const lineword = model.getLineContent(position.lineNumber) // 获取光标悬停所在行的所有内容
  //     const word = model.getWordAtPosition(position)?.word // 获取光标悬停的单词
  //     if (word === "int") {
  //       return {
  //         contents: [
  //           { value: `${word}` },
  //           {
  //             supportHtml: true,
  //             value: /* '<span style="color:#ff0000;">这是一段简介</span><br><span style="color:#000000;">这是一段简介</span>' */
  //               [
  //                 "这是name的一些介绍1",
  //                 "这是name的一些介绍2",
  //               ].join("\n\n"),
  //           },
  //         ],
  //       };
  //     }
  //   },
  // });
  //注册语言为*，注册为lua会将原有的本地单词提示替换
  monaco.languages.registerCompletionItemProvider('*', {
    provideCompletionItems: () => {
      return {
        suggestions: [
          {
            label: 'local ..',
            kind: 27,
            detail: 'local x = 1',
            insertText: 'local ${1:x} = ${2:1}',
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'function ..',
            kind: 27,
            detail: 'function fname()\n-- body\nend',
            insertText: 'function ${1:fname}()\n-- body\nend',
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },

          {
            label: 'for',
            kind: 27,
            detail: 'for i=1,10 do\n   \nend',
            insertText: 'for ${1:i}=${2:1},${3:10} do\n   \nend',
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'for .. ipairs',
            kind: 27,
            detail: 'for index, value in ipairs(t) do\n    -- body\nend',
            insertText: 'for ${1:index}, ${2:value} in ipairs(${3:t}) do\n    -- body\nend',
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'for .. pairs',
            kind: 27,
            detail: 'for key, value in pairs(t) do\n    -- body\nend',
            insertText: 'for ${1:key}, ${2:value} in pairs(${3:t}) do\n    -- body\nend',
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'do .. end',
            kind: 27,
            detail: 'do\n\t\nend',
            insertText: "do\n\t$0\nend",
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'elseif .. then',
            kind: 27,
            detail: 'elseif  then',
            insertText: "elseif $0 then",
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'if .. then',
            kind: 27,
            detail: 'if  then\n\t\nend',
            insertText: "if $1 then\n\t$0\nend",
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'in ..',
            kind: 27,
            detail: 'in pairs(t) do\n\t\nend',
            insertText: "in ${1:pairs(${2:t})} do\n\t$0\nend",
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'repeat .. until',
            kind: 27,
            detail: 'repeat\n\t\nuntil ',
            insertText: "repeat\n\t$0\nuntil $1",
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'do return end',
            kind: 27,
            detail: 'do return end',
            insertText: "do return $1end",
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'then .. end',
            kind: 27,
            detail: 'then\n\t\nend',
            insertText: 'then\n\t$0\nend',
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
          {
            label: 'while .. do',
            kind: 27,
            detail: 'while true do\n\t\nend',
            insertText: 'while ${1:true} do\n\t$0\nend',
            insertTextRules: monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet,
          },
        ]
      };
    }
  });



  let keywords = (
    "break|do|else|elseif|end|for|function|if|in|local|repeat|" +
    "return|then|until|while|or|and|not|").split(
      "|");
  monaco.languages.registerCompletionItemProvider('*', {
    provideCompletionItems: (model, position) => {
      const suggestions = keywords.map(keyword => ({
        label: keyword,
        kind: 17,
        insertText: keyword
      }
      ));
      return { suggestions };
    }
  });


  let builtinConstants = (
    "true|false|nil|_G|_VERSION|").split(
      "|");
  monaco.languages.registerCompletionItemProvider('*', {
    provideCompletionItems: (model, position) => {
      const suggestions = builtinConstants.map(keyword => ({
        label: keyword,
        kind: 14,
        insertText: keyword
      }
      ));
      return { suggestions };
    }
  });

  let functions = (
    "string|xpcall|package|tostring|print|os|unpack|require|" +
    "getfenv|next|assert|tonumber|io|rawequal|" +
    "collectgarbage|module|rawset|math|debug|" +
    "pcall|table|newproxy|coroutine|select|gcinfo|" +
    "pairs|rawget|loadstring|ipairs|_VERSION|dofile|" +
    "load|error|loadfile|" +
    "sub|upper|len|gfind|rep|find|match|char|dump|gmatch|" +
    "reverse|byte|format|gsub|lower|preload|loadlib|loaded|" +
    "loaders|cpath|config|path|seeall|exit|setlocale|date|" +
    "getenv|difftime|remove|time|clock|tmpname|rename|execute|" +
    "lines|write|close|flush|open|output|type|read|stderr|" +
    "stdin|input|stdout|popen|tmpfile|log|max|acos|huge|" +
    "ldexp|pi|cos|tanh|pow|deg|tan|cosh|sinh|random|randomseed|" +
    "frexp|ceil|floor|rad|abs|sqrt|modf|asin|min|mod|fmod|log10|" +
    "atan2|exp|sin|atan|getupvalue|sethook|getmetatable|" +
    "gethook|setmetatable|setlocal|traceback|setfenv|getinfo|" +
    "setupvalue|getlocal|getregistry|setn|insert|getn|" +
    "foreachi|maxn|foreach|concat|sort|resume|yield|" +
    "status|wrap|create|running|" +
    "__add|__sub|__mod|__unm|__concat|__lt|__index|__call|__gc|__metatable|" +
    "__mul|__div|__pow|__len|__eq|__le|__newindex|__tostring|__mode|__tonumber").split(
      "|");
  monaco.languages.registerCompletionItemProvider('*', {
    provideCompletionItems: (model, position) => {
      const suggestions = functions.map(keyword => ({
        label: keyword,
        kind: 1,
        insertText: keyword
      }
      ));
      return { suggestions };
    }
  });


}