let options = {
  value: `   --[[--
    num_args takes in 5.1 byte code and extracts the number of arguments
    from its function header.
    --]]--
    
    function int(t)
        return t:byte(1)+t:byte(2)*0x100+t:byte(3)*0x10000+t:byte(4)*0x1000000
    end
    
    function num_args(func)
        local dump = string.dump(func)
        local offset, cursor = int(dump:sub(13)), offset + 26
        --Get the params and var flag (whether there's a ... in the param)
        return dump:sub(cursor):byte(), dump:sub(cursor+1):byte()
    end
`,
  theme: "white",
  language: "lua",
  automaticLayout: true,
  fontSize: 20,
  minimap: {
    enabled: true, // 是否启用预览图
    size: 'fill'
  },
  scrollbar: {
    horizontal: "auto"
  }
}