function getFunctionName(text) {
  let parser = getFunction.parse(text, { wait: true });
  let word = ""
  let value = ""
  let newValue = ""
  let line = 1;
  let lineStart = 0;
  let rangeStart = 0;
  let rnageEnd = 0;
  do {
    word = parser.lex();
    value += word.value

    while (line < word.line) {
      newValue += "\n"
      line++
      lineStart = word.lineStart
    }
    rangeStart = word.range[0];
    rnageEnd = word.range[1];
    for (; lineStart < rangeStart; lineStart++) {
      newValue += " "
    }
    newValue += word.value;
    lineStart = rnageEnd;
  } while (word.value != "<eof>")
  console.log(value)
  console.log(newValue)

  // 匹配 Lua 函数名的正则表达式 
  // function xx(xx)
  const functionPattern = /function\s+([\w\d_\u4e00-\u9fa5]+)\s*\([^)]*\)/g;
  // xx = function ()
  const functionRegex = /([\w\d_\u4e00-\u9fa5]+)\s*=\s*function\s*\([^)]*\)/g;


  // 匹配函数名及其位置
  let match;
  let functionList = [];

  while ((match = functionPattern.exec(newValue)) !== null) {
    let functionName = match[1]; // 获取函数名
    let startIndex = match.index + 1; // 获取函数名在文本中的起始位置
    let lineStart = newValue.substr(0, startIndex).split("\n").length; // 获取函数名所在行数
    let column = startIndex - newValue.lastIndexOf("\n", startIndex) + 7; // 获取函数名在其所在行的列数
    let functionObj = {};
    functionObj.name = functionName;
    functionObj.cow = lineStart;
    functionObj.column = column;
    functionList.push(functionObj);
    console.log(`函数名: ${functionName}, 在第 ${lineStart} 行, 第 ${column} 列`);
  }

  while ((match = functionRegex.exec(newValue)) !== null) {
    let functionName = match[1]; // 获取函数名
    let startIndex = match.index + 1; // 获取函数名在文本中的起始位置
    let lineStart = newValue.substr(0, startIndex).split("\n").length; // 获取函数名所在行数
    let column = startIndex - newValue.lastIndexOf("\n", startIndex) - 2; // 获取函数名在其所在行的列数
    let functionObj = {};
    functionObj.name = functionName;
    functionObj.cow = lineStart;
    functionObj.column = column;
    functionList.push(functionObj);
    console.log(`函数名: ${functionName}, 在第 ${lineStart} 行, 第 ${column} 列`);
  }
  //对象列表进行排序
  functionList.sort((a, b) => { if (a.cow === b.cow) { return a.column - b.column; } else { return a.cow - b.cow; } });
  console.log(functionList)
  const jsonString = JSON.stringify(functionList);
  console.log(jsonString)
  alert(jsonString)
}