/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.x500.X500Principal;
import sun.security.internal.spec.TlsPrfParameterSpec;
import sun.security.ssl.ALPNExtension;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.EllipticCurvesExtension;
import sun.security.ssl.ExtendedMasterSecretExtension;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtensions;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSASignature;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.ServerNameExtension;
import sun.security.ssl.SessionId;
import sun.security.ssl.SignatureAlgorithmsExtension;
import sun.security.ssl.SignatureAndHashAlgorithm;
import sun.security.util.KeyUtil;

public abstract class HandshakeMessage {
    static final byte ht_hello_request = 0;
    static final byte ht_client_hello = 1;
    static final byte ht_server_hello = 2;
    static final byte ht_certificate = 11;
    static final byte ht_server_key_exchange = 12;
    static final byte ht_certificate_request = 13;
    static final byte ht_server_hello_done = 14;
    static final byte ht_certificate_verify = 15;
    static final byte ht_client_key_exchange = 16;
    static final byte ht_finished = 20;
    static final byte ht_not_applicable = -1;
    public static final Debug debug = Debug.getInstance("ssl");
    static final byte[] MD5_pad1 = HandshakeMessage.genPad(54, 48);
    static final byte[] MD5_pad2 = HandshakeMessage.genPad(92, 48);
    static final byte[] SHA_pad1 = HandshakeMessage.genPad(54, 40);
    static final byte[] SHA_pad2 = HandshakeMessage.genPad(92, 40);

    HandshakeMessage() {
    }

    static byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 1 && byArray[0] == 0) {
            int n = byArray.length - 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    private static byte[] genPad(int n, int n2) {
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, (byte)n);
        return byArray;
    }

    final void write(HandshakeOutStream handshakeOutStream) throws IOException {
        int n = this.messageLength();
        if (n >= 0x1000000) {
            throw new SSLException("Handshake message too big, type = " + this.messageType() + ", len = " + n);
        }
        handshakeOutStream.write(this.messageType());
        handshakeOutStream.putInt24(n);
        this.send(handshakeOutStream);
    }

    abstract int messageType();

    abstract int messageLength();

    abstract void send(HandshakeOutStream var1) throws IOException;

    abstract void print(PrintStream var1) throws IOException;

    static final class CertificateMsg
    extends HandshakeMessage {
        private X509Certificate[] chain;
        private List<byte[]> encodedChain;
        private int messageLength;

        @Override
        int messageType() {
            return 11;
        }

        CertificateMsg(X509Certificate[] x509CertificateArray) {
            this.chain = x509CertificateArray;
        }

        CertificateMsg(HandshakeInStream handshakeInStream) throws IOException {
            int n = handshakeInStream.getInt24();
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>(4);
            CertificateFactory certificateFactory = null;
            while (n > 0) {
                byte[] byArray = handshakeInStream.getBytes24();
                n -= 3 + byArray.length;
                try {
                    if (certificateFactory == null) {
                        certificateFactory = CertificateFactory.getInstance("X.509");
                    }
                    arrayList.add(certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
                }
                catch (CertificateException certificateException) {
                    throw (SSLProtocolException)new SSLProtocolException(certificateException.getMessage()).initCause(certificateException);
                }
            }
            this.chain = arrayList.toArray(new X509Certificate[arrayList.size()]);
        }

        @Override
        int messageLength() {
            if (this.encodedChain == null) {
                this.messageLength = 3;
                this.encodedChain = new ArrayList<byte[]>(this.chain.length);
                try {
                    for (X509Certificate x509Certificate : this.chain) {
                        byte[] byArray = x509Certificate.getEncoded();
                        this.encodedChain.add(byArray);
                        this.messageLength += byArray.length + 3;
                    }
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    this.encodedChain = null;
                    throw new RuntimeException("Could not encode certificates", certificateEncodingException);
                }
            }
            return this.messageLength;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt24(this.messageLength() - 3);
            for (byte[] byArray : this.encodedChain) {
                handshakeOutStream.putBytes24(byArray);
            }
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** Certificate chain");
            if (this.chain.length == 0) {
                printStream.println("<Empty>");
            } else if (debug != null && Debug.isOn("verbose")) {
                for (int i = 0; i < this.chain.length; ++i) {
                    printStream.println("chain [" + i + "] = " + this.chain[i]);
                }
            }
            printStream.println("***");
        }

        X509Certificate[] getCertificateChain() {
            return (X509Certificate[])this.chain.clone();
        }
    }

    static final class CertificateRequest
    extends HandshakeMessage {
        static final int cct_rsa_sign = 1;
        static final int cct_dss_sign = 2;
        static final int cct_rsa_fixed_dh = 3;
        static final int cct_dss_fixed_dh = 4;
        static final int cct_rsa_ephemeral_dh = 5;
        static final int cct_dss_ephemeral_dh = 6;
        static final int cct_ecdsa_sign = 64;
        static final int cct_rsa_fixed_ecdh = 65;
        static final int cct_ecdsa_fixed_ecdh = 66;
        private static final byte[] TYPES_NO_ECC = new byte[]{1, 2};
        private static final byte[] TYPES_ECC = new byte[]{1, 2, 64};
        byte[] types;
        DistinguishedName[] authorities;
        ProtocolVersion protocolVersion;
        private Collection<SignatureAndHashAlgorithm> algorithms;
        private int algorithmsLen;

        CertificateRequest(X509Certificate[] x509CertificateArray, CipherSuite.KeyExchange keyExchange, Collection<SignatureAndHashAlgorithm> collection, ProtocolVersion protocolVersion) throws IOException {
            this.protocolVersion = protocolVersion;
            this.authorities = new DistinguishedName[x509CertificateArray.length];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                X500Principal x500Principal = x509CertificateArray[i].getSubjectX500Principal();
                this.authorities[i] = new DistinguishedName(x500Principal);
            }
            byte[] byArray = this.types = JsseJce.isEcAvailable() ? TYPES_ECC : TYPES_NO_ECC;
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                if (collection == null || collection.isEmpty()) {
                    throw new SSLProtocolException("No supported signature algorithms");
                }
                this.algorithms = new ArrayList<SignatureAndHashAlgorithm>(collection);
                this.algorithmsLen = SignatureAndHashAlgorithm.sizeInRecord() * this.algorithms.size();
            } else {
                this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
                this.algorithmsLen = 0;
            }
        }

        CertificateRequest(HandshakeInStream handshakeInStream, ProtocolVersion protocolVersion) throws IOException {
            DistinguishedName distinguishedName;
            int n;
            this.protocolVersion = protocolVersion;
            this.types = handshakeInStream.getBytes8();
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                this.algorithmsLen = handshakeInStream.getInt16();
                if (this.algorithmsLen < 2) {
                    throw new SSLProtocolException("Invalid supported_signature_algorithms field: " + this.algorithmsLen);
                }
                this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
                int n2 = 0;
                for (n = this.algorithmsLen; n > 1; n -= 2) {
                    int n3 = handshakeInStream.getInt8();
                    int n4 = handshakeInStream.getInt8();
                    SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.valueOf(n3, n4, ++n2);
                    this.algorithms.add(signatureAndHashAlgorithm);
                }
                if (n != 0) {
                    throw new SSLProtocolException("Invalid supported_signature_algorithms field. remains: " + n);
                }
            } else {
                this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
                this.algorithmsLen = 0;
            }
            ArrayList<DistinguishedName> arrayList = new ArrayList<DistinguishedName>();
            for (n = handshakeInStream.getInt16(); n >= 3; n -= distinguishedName.length()) {
                distinguishedName = new DistinguishedName(handshakeInStream);
                arrayList.add(distinguishedName);
            }
            if (n != 0) {
                throw new SSLProtocolException("Bad CertificateRequest DN length: " + n);
            }
            this.authorities = arrayList.toArray(new DistinguishedName[arrayList.size()]);
        }

        X500Principal[] getAuthorities() throws IOException {
            X500Principal[] x500PrincipalArray = new X500Principal[this.authorities.length];
            for (int i = 0; i < this.authorities.length; ++i) {
                x500PrincipalArray[i] = this.authorities[i].getX500Principal();
            }
            return x500PrincipalArray;
        }

        Collection<SignatureAndHashAlgorithm> getSignAlgorithms() {
            return this.algorithms;
        }

        @Override
        int messageType() {
            return 13;
        }

        @Override
        int messageLength() {
            int n = 1 + this.types.length + 2;
            if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                n += this.algorithmsLen + 2;
            }
            for (int i = 0; i < this.authorities.length; ++i) {
                n += this.authorities[i].length();
            }
            return n;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            int n;
            handshakeOutStream.putBytes8(this.types);
            if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                handshakeOutStream.putInt16(this.algorithmsLen);
                for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : this.algorithms) {
                    handshakeOutStream.putInt8(signatureAndHashAlgorithm.getHashValue());
                    handshakeOutStream.putInt8(signatureAndHashAlgorithm.getSignatureValue());
                }
            }
            int n2 = 0;
            for (n = 0; n < this.authorities.length; ++n) {
                n2 += this.authorities[n].length();
            }
            handshakeOutStream.putInt16(n2);
            for (n = 0; n < this.authorities.length; ++n) {
                this.authorities[n].send(handshakeOutStream);
            }
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** CertificateRequest");
            if (debug != null && Debug.isOn("verbose")) {
                int n;
                printStream.print("Cert Types: ");
                for (n = 0; n < this.types.length; ++n) {
                    switch (this.types[n]) {
                        case 1: {
                            printStream.print("RSA");
                            break;
                        }
                        case 2: {
                            printStream.print("DSS");
                            break;
                        }
                        case 3: {
                            printStream.print("Fixed DH (RSA sig)");
                            break;
                        }
                        case 4: {
                            printStream.print("Fixed DH (DSS sig)");
                            break;
                        }
                        case 5: {
                            printStream.print("Ephemeral DH (RSA sig)");
                            break;
                        }
                        case 6: {
                            printStream.print("Ephemeral DH (DSS sig)");
                            break;
                        }
                        case 64: {
                            printStream.print("ECDSA");
                            break;
                        }
                        case 65: {
                            printStream.print("Fixed ECDH (RSA sig)");
                            break;
                        }
                        case 66: {
                            printStream.print("Fixed ECDH (ECDSA sig)");
                            break;
                        }
                        default: {
                            printStream.print("Type-" + (this.types[n] & 0xFF));
                        }
                    }
                    if (n == this.types.length - 1) continue;
                    printStream.print(", ");
                }
                printStream.println();
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = false;
                    for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : this.algorithms) {
                        if (bl) {
                            stringBuffer.append(", " + signatureAndHashAlgorithm.getAlgorithmName());
                            continue;
                        }
                        stringBuffer.append(signatureAndHashAlgorithm.getAlgorithmName());
                        bl = true;
                    }
                    printStream.println("Supported Signature Algorithms: " + stringBuffer);
                }
                printStream.println("Cert Authorities:");
                if (this.authorities.length == 0) {
                    printStream.println("<Empty>");
                } else {
                    for (n = 0; n < this.authorities.length; ++n) {
                        this.authorities[n].print(printStream);
                    }
                }
            }
        }
    }

    static final class CertificateVerify
    extends HandshakeMessage {
        private byte[] signature;
        ProtocolVersion protocolVersion;
        private SignatureAndHashAlgorithm preferableSignatureAlgorithm = null;
        private static final Class<?> delegate;
        private static final Field spiField;
        private static final Object NULL_OBJECT;
        private static final Map<Class<?>, Object> methodCache;

        CertificateVerify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, PrivateKey privateKey, SecretKey secretKey, SecureRandom secureRandom, SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws GeneralSecurityException {
            this.protocolVersion = protocolVersion;
            String string = privateKey.getAlgorithm();
            Signature signature = null;
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                this.preferableSignatureAlgorithm = signatureAndHashAlgorithm;
                signature = JsseJce.getSignature(signatureAndHashAlgorithm.getAlgorithmName());
            } else {
                signature = CertificateVerify.getSignature(protocolVersion, string);
            }
            signature.initSign(privateKey, secureRandom);
            CertificateVerify.updateSignature(signature, protocolVersion, handshakeHash, string, secretKey);
            this.signature = signature.sign();
        }

        CertificateVerify(HandshakeInStream handshakeInStream, Collection<SignatureAndHashAlgorithm> collection, ProtocolVersion protocolVersion) throws IOException {
            this.protocolVersion = protocolVersion;
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                int n = handshakeInStream.getInt8();
                int n2 = handshakeInStream.getInt8();
                this.preferableSignatureAlgorithm = SignatureAndHashAlgorithm.valueOf(n, n2, 0);
                if (!collection.contains(this.preferableSignatureAlgorithm)) {
                    throw new SSLHandshakeException("Unsupported SignatureAndHashAlgorithm in CertificateVerify message: " + this.preferableSignatureAlgorithm);
                }
            }
            this.signature = handshakeInStream.getBytes16();
        }

        SignatureAndHashAlgorithm getPreferableSignatureAlgorithm() {
            return this.preferableSignatureAlgorithm;
        }

        boolean verify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, PublicKey publicKey, SecretKey secretKey) throws GeneralSecurityException {
            String string = publicKey.getAlgorithm();
            Signature signature = null;
            signature = protocolVersion.v >= ProtocolVersion.TLS12.v ? JsseJce.getSignature(this.preferableSignatureAlgorithm.getAlgorithmName()) : CertificateVerify.getSignature(protocolVersion, string);
            signature.initVerify(publicKey);
            CertificateVerify.updateSignature(signature, protocolVersion, handshakeHash, string, secretKey);
            return signature.verify(this.signature);
        }

        private static Signature getSignature(ProtocolVersion protocolVersion, String string) throws GeneralSecurityException {
            switch (string) {
                case "RSA": {
                    return RSASignature.getInternalInstance();
                }
                case "DSA": {
                    return JsseJce.getSignature("RawDSA");
                }
                case "EC": {
                    return JsseJce.getSignature("NONEwithECDSA");
                }
            }
            throw new SignatureException("Unrecognized algorithm: " + string);
        }

        private static void updateSignature(Signature signature, ProtocolVersion protocolVersion, HandshakeHash handshakeHash, String string, SecretKey secretKey) throws SignatureException {
            if (string.equals("RSA")) {
                if (protocolVersion.v < ProtocolVersion.TLS12.v) {
                    MessageDigest messageDigest = handshakeHash.getMD5Clone();
                    MessageDigest messageDigest2 = handshakeHash.getSHAClone();
                    if (protocolVersion.v < ProtocolVersion.TLS10.v) {
                        CertificateVerify.updateDigest(messageDigest, MD5_pad1, MD5_pad2, secretKey);
                        CertificateVerify.updateDigest(messageDigest2, SHA_pad1, SHA_pad2, secretKey);
                    }
                    RSASignature.setHashes(signature, messageDigest, messageDigest2);
                } else {
                    signature.update(handshakeHash.getAllHandshakeMessages());
                }
            } else if (protocolVersion.v < ProtocolVersion.TLS12.v) {
                MessageDigest messageDigest = handshakeHash.getSHAClone();
                if (protocolVersion.v < ProtocolVersion.TLS10.v) {
                    CertificateVerify.updateDigest(messageDigest, SHA_pad1, SHA_pad2, secretKey);
                }
                signature.update(messageDigest.digest());
            } else {
                signature.update(handshakeHash.getAllHandshakeMessages());
            }
        }

        private static void updateDigest(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, SecretKey secretKey) {
            byte[] byArray3;
            byte[] byArray4 = byArray3 = "RAW".equals(secretKey.getFormat()) ? secretKey.getEncoded() : null;
            if (byArray3 != null) {
                messageDigest.update(byArray3);
            } else {
                CertificateVerify.digestKey(messageDigest, secretKey);
            }
            messageDigest.update(byArray);
            byte[] byArray5 = messageDigest.digest();
            if (byArray3 != null) {
                messageDigest.update(byArray3);
            } else {
                CertificateVerify.digestKey(messageDigest, secretKey);
            }
            messageDigest.update(byArray2);
            messageDigest.update(byArray5);
        }

        private static void makeAccessible(final AccessibleObject accessibleObject) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    accessibleObject.setAccessible(true);
                    return null;
                }
            });
        }

        private static void digestKey(MessageDigest messageDigest, SecretKey secretKey) {
            try {
                if (messageDigest.getClass() != delegate) {
                    throw new Exception("Digest is not a MessageDigestSpi");
                }
                MessageDigestSpi messageDigestSpi = (MessageDigestSpi)spiField.get(messageDigest);
                Class<?> clazz = messageDigestSpi.getClass();
                Object object = methodCache.get(clazz);
                if (object == null) {
                    try {
                        object = clazz.getDeclaredMethod("implUpdate", SecretKey.class);
                        CertificateVerify.makeAccessible((Method)object);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        object = NULL_OBJECT;
                    }
                    methodCache.put(clazz, object);
                }
                if (object == NULL_OBJECT) {
                    throw new Exception("Digest does not support implUpdate(SecretKey)");
                }
                Method method = (Method)object;
                method.invoke((Object)messageDigestSpi, secretKey);
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not obtain encoded key and MessageDigest cannot digest key", exception);
            }
        }

        @Override
        int messageType() {
            return 15;
        }

        @Override
        int messageLength() {
            int n = 2;
            if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                n += SignatureAndHashAlgorithm.sizeInRecord();
            }
            return n + this.signature.length;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                handshakeOutStream.putInt8(this.preferableSignatureAlgorithm.getHashValue());
                handshakeOutStream.putInt8(this.preferableSignatureAlgorithm.getSignatureValue());
            }
            handshakeOutStream.putBytes16(this.signature);
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** CertificateVerify");
            if (debug != null && Debug.isOn("verbose") && this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                printStream.println("Signature Algorithm " + this.preferableSignatureAlgorithm.getAlgorithmName());
            }
        }

        static {
            try {
                delegate = Class.forName("java.security.MessageDigest$Delegate");
                spiField = delegate.getDeclaredField("digestSpi");
            }
            catch (Exception exception) {
                throw new RuntimeException("Reflection failed", exception);
            }
            CertificateVerify.makeAccessible(spiField);
            NULL_OBJECT = new Object();
            methodCache = new ConcurrentHashMap();
        }
    }

    static final class ClientHello
    extends HandshakeMessage {
        ProtocolVersion protocolVersion;
        RandomCookie clnt_random;
        SessionId sessionId;
        private CipherSuiteList cipherSuites;
        byte[] compression_methods;
        HelloExtensions extensions = new HelloExtensions();
        private static final byte[] NULL_COMPRESSION = new byte[]{0};

        ClientHello(SecureRandom secureRandom, ProtocolVersion protocolVersion, SessionId sessionId, CipherSuiteList cipherSuiteList) {
            this.protocolVersion = protocolVersion;
            this.sessionId = sessionId;
            this.cipherSuites = cipherSuiteList;
            this.clnt_random = new RandomCookie(secureRandom);
            this.compression_methods = NULL_COMPRESSION;
        }

        ClientHello(HandshakeInStream handshakeInStream, int n) throws IOException {
            this.protocolVersion = ProtocolVersion.valueOf(handshakeInStream.getInt8(), handshakeInStream.getInt8());
            this.clnt_random = new RandomCookie(handshakeInStream);
            this.sessionId = new SessionId(handshakeInStream.getBytes8());
            this.sessionId.checkLength(this.protocolVersion);
            this.cipherSuites = new CipherSuiteList(handshakeInStream);
            this.compression_methods = handshakeInStream.getBytes8();
            if (this.messageLength() != n) {
                this.extensions = new HelloExtensions(handshakeInStream);
            }
        }

        CipherSuiteList getCipherSuites() {
            return this.cipherSuites;
        }

        void addRenegotiationInfoExtension(byte[] byArray) {
            RenegotiationInfoExtension renegotiationInfoExtension = new RenegotiationInfoExtension(byArray, new byte[0]);
            this.extensions.add(renegotiationInfoExtension);
        }

        void addSNIExtension(List<SNIServerName> list) {
            try {
                this.extensions.add(new ServerNameExtension(list));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void addSignatureAlgorithmsExtension(Collection<SignatureAndHashAlgorithm> collection) {
            SignatureAlgorithmsExtension signatureAlgorithmsExtension = new SignatureAlgorithmsExtension(collection);
            this.extensions.add(signatureAlgorithmsExtension);
        }

        void addExtendedMasterSecretExtension() {
            this.extensions.add(new ExtendedMasterSecretExtension());
        }

        void addALPNExtension(String[] stringArray) throws SSLException {
            this.extensions.add(new ALPNExtension(stringArray));
        }

        @Override
        int messageType() {
            return 1;
        }

        @Override
        int messageLength() {
            return 38 + this.sessionId.length() + this.cipherSuites.size() * 2 + this.compression_methods.length + this.extensions.length();
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(this.protocolVersion.major);
            handshakeOutStream.putInt8(this.protocolVersion.minor);
            this.clnt_random.send(handshakeOutStream);
            handshakeOutStream.putBytes8(this.sessionId.getId());
            this.cipherSuites.send(handshakeOutStream);
            handshakeOutStream.putBytes8(this.compression_methods);
            this.extensions.send(handshakeOutStream);
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ClientHello, " + this.protocolVersion);
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("RandomCookie:  ");
                this.clnt_random.print(printStream);
                printStream.print("Session ID:  ");
                printStream.println(this.sessionId);
                printStream.println("Cipher Suites: " + this.cipherSuites);
                Debug.println(printStream, "Compression Methods", this.compression_methods);
                this.extensions.print(printStream);
                printStream.println("***");
            }
        }
    }

    static final class DH_ServerKeyExchange
    extends ServerKeyExchange {
        private static final boolean dhKeyExchangeFix = Debug.getBooleanProperty("com.sun.net.ssl.dhKeyExchangeFix", true);
        private byte[] dh_p;
        private byte[] dh_g;
        private byte[] dh_Ys;
        private byte[] signature;
        ProtocolVersion protocolVersion;
        private SignatureAndHashAlgorithm preferableSignatureAlgorithm;

        DH_ServerKeyExchange(DHCrypt dHCrypt, ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            this.preferableSignatureAlgorithm = null;
            this.setValues(dHCrypt);
            this.signature = null;
        }

        DH_ServerKeyExchange(DHCrypt dHCrypt, PrivateKey privateKey, byte[] byArray, byte[] byArray2, SecureRandom secureRandom, SignatureAndHashAlgorithm signatureAndHashAlgorithm, ProtocolVersion protocolVersion) throws GeneralSecurityException {
            Signature signature;
            this.protocolVersion = protocolVersion;
            this.setValues(dHCrypt);
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                this.preferableSignatureAlgorithm = signatureAndHashAlgorithm;
                signature = JsseJce.getSignature(signatureAndHashAlgorithm.getAlgorithmName());
            } else {
                this.preferableSignatureAlgorithm = null;
                signature = privateKey.getAlgorithm().equals("DSA") ? JsseJce.getSignature("DSA") : RSASignature.getInstance();
            }
            signature.initSign(privateKey, secureRandom);
            this.updateSignature(signature, byArray, byArray2);
            this.signature = signature.sign();
        }

        DH_ServerKeyExchange(HandshakeInStream handshakeInStream, ProtocolVersion protocolVersion) throws IOException, GeneralSecurityException {
            this.protocolVersion = protocolVersion;
            this.preferableSignatureAlgorithm = null;
            this.dh_p = handshakeInStream.getBytes16();
            this.dh_g = handshakeInStream.getBytes16();
            this.dh_Ys = handshakeInStream.getBytes16();
            KeyUtil.validate(new DHPublicKeySpec(new BigInteger(1, this.dh_Ys), new BigInteger(1, this.dh_p), new BigInteger(1, this.dh_g)));
            this.signature = null;
        }

        DH_ServerKeyExchange(HandshakeInStream handshakeInStream, PublicKey publicKey, byte[] byArray, byte[] byArray2, int n, Collection<SignatureAndHashAlgorithm> collection, ProtocolVersion protocolVersion) throws IOException, GeneralSecurityException {
            Signature signature;
            byte[] byArray3;
            this.protocolVersion = protocolVersion;
            this.dh_p = handshakeInStream.getBytes16();
            this.dh_g = handshakeInStream.getBytes16();
            this.dh_Ys = handshakeInStream.getBytes16();
            KeyUtil.validate(new DHPublicKeySpec(new BigInteger(1, this.dh_Ys), new BigInteger(1, this.dh_p), new BigInteger(1, this.dh_g)));
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                int n2 = handshakeInStream.getInt8();
                int n3 = handshakeInStream.getInt8();
                this.preferableSignatureAlgorithm = SignatureAndHashAlgorithm.valueOf(n2, n3, 0);
                if (!collection.contains(this.preferableSignatureAlgorithm)) {
                    throw new SSLHandshakeException("Unsupported SignatureAndHashAlgorithm in ServerKeyExchange message: " + this.preferableSignatureAlgorithm);
                }
            } else {
                this.preferableSignatureAlgorithm = null;
            }
            if (dhKeyExchangeFix) {
                byArray3 = handshakeInStream.getBytes16();
            } else {
                n -= this.dh_p.length + 2;
                n -= this.dh_g.length + 2;
                byArray3 = new byte[n -= this.dh_Ys.length + 2];
                handshakeInStream.read(byArray3);
            }
            String string = publicKey.getAlgorithm();
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                signature = JsseJce.getSignature(this.preferableSignatureAlgorithm.getAlgorithmName());
            } else {
                switch (string) {
                    case "DSA": {
                        signature = JsseJce.getSignature("DSA");
                        break;
                    }
                    case "RSA": {
                        signature = RSASignature.getInstance();
                        break;
                    }
                    default: {
                        throw new SSLKeyException("neither an RSA or a DSA key: " + string);
                    }
                }
            }
            signature.initVerify(publicKey);
            this.updateSignature(signature, byArray, byArray2);
            if (!signature.verify(byArray3)) {
                throw new SSLKeyException("Server D-H key verification failed");
            }
        }

        BigInteger getModulus() {
            return new BigInteger(1, this.dh_p);
        }

        BigInteger getBase() {
            return new BigInteger(1, this.dh_g);
        }

        BigInteger getServerPublicKey() {
            return new BigInteger(1, this.dh_Ys);
        }

        private void updateSignature(Signature signature, byte[] byArray, byte[] byArray2) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            int n = this.dh_p.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.dh_p);
            n = this.dh_g.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.dh_g);
            n = this.dh_Ys.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.dh_Ys);
        }

        private void setValues(DHCrypt dHCrypt) {
            this.dh_p = DH_ServerKeyExchange.toByteArray(dHCrypt.getModulus());
            this.dh_g = DH_ServerKeyExchange.toByteArray(dHCrypt.getBase());
            this.dh_Ys = DH_ServerKeyExchange.toByteArray(dHCrypt.getPublicKey());
        }

        @Override
        int messageLength() {
            int n = 6;
            n += this.dh_p.length;
            n += this.dh_g.length;
            n += this.dh_Ys.length;
            if (this.signature != null) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    n += SignatureAndHashAlgorithm.sizeInRecord();
                }
                n += this.signature.length;
                if (dhKeyExchangeFix) {
                    n += 2;
                }
            }
            return n;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.dh_p);
            handshakeOutStream.putBytes16(this.dh_g);
            handshakeOutStream.putBytes16(this.dh_Ys);
            if (this.signature != null) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    handshakeOutStream.putInt8(this.preferableSignatureAlgorithm.getHashValue());
                    handshakeOutStream.putInt8(this.preferableSignatureAlgorithm.getSignatureValue());
                }
                if (dhKeyExchangeFix) {
                    handshakeOutStream.putBytes16(this.signature);
                } else {
                    handshakeOutStream.write(this.signature);
                }
            }
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** Diffie-Hellman ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                Debug.println(printStream, "DH Modulus", this.dh_p);
                Debug.println(printStream, "DH Base", this.dh_g);
                Debug.println(printStream, "Server DH Public Key", this.dh_Ys);
                if (this.signature == null) {
                    printStream.println("Anonymous");
                } else {
                    if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                        printStream.println("Signature Algorithm " + this.preferableSignatureAlgorithm.getAlgorithmName());
                    }
                    printStream.println("Signed with a DSA or RSA public key");
                }
            }
        }
    }

    static final class DistinguishedName {
        byte[] name;

        DistinguishedName(HandshakeInStream handshakeInStream) throws IOException {
            this.name = handshakeInStream.getBytes16();
        }

        DistinguishedName(X500Principal x500Principal) {
            this.name = x500Principal.getEncoded();
        }

        X500Principal getX500Principal() throws IOException {
            try {
                return new X500Principal(this.name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (SSLProtocolException)new SSLProtocolException(illegalArgumentException.getMessage()).initCause(illegalArgumentException);
            }
        }

        int length() {
            return 2 + this.name.length;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.name);
        }

        void print(PrintStream printStream) throws IOException {
            X500Principal x500Principal = new X500Principal(this.name);
            printStream.println("<" + x500Principal.toString() + ">");
        }
    }

    static final class ECDH_ServerKeyExchange
    extends ServerKeyExchange {
        private static final int CURVE_EXPLICIT_PRIME = 1;
        private static final int CURVE_EXPLICIT_CHAR2 = 2;
        private static final int CURVE_NAMED_CURVE = 3;
        private int curveId;
        private byte[] pointBytes;
        private byte[] signatureBytes;
        private ECPublicKey publicKey;
        ProtocolVersion protocolVersion;
        private SignatureAndHashAlgorithm preferableSignatureAlgorithm;

        ECDH_ServerKeyExchange(ECDHCrypt eCDHCrypt, PrivateKey privateKey, byte[] byArray, byte[] byArray2, SecureRandom secureRandom, SignatureAndHashAlgorithm signatureAndHashAlgorithm, ProtocolVersion protocolVersion) throws GeneralSecurityException {
            Signature signature;
            this.protocolVersion = protocolVersion;
            this.publicKey = (ECPublicKey)eCDHCrypt.getPublicKey();
            ECParameterSpec eCParameterSpec = this.publicKey.getParams();
            ECPoint eCPoint = this.publicKey.getW();
            this.pointBytes = JsseJce.encodePoint(eCPoint, eCParameterSpec.getCurve());
            this.curveId = EllipticCurvesExtension.getCurveIndex(eCParameterSpec);
            if (privateKey == null) {
                return;
            }
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                this.preferableSignatureAlgorithm = signatureAndHashAlgorithm;
                signature = JsseJce.getSignature(signatureAndHashAlgorithm.getAlgorithmName());
            } else {
                signature = ECDH_ServerKeyExchange.getSignature(privateKey.getAlgorithm());
            }
            signature.initSign(privateKey, secureRandom);
            this.updateSignature(signature, byArray, byArray2);
            this.signatureBytes = signature.sign();
        }

        ECDH_ServerKeyExchange(HandshakeInStream handshakeInStream, PublicKey publicKey, byte[] byArray, byte[] byArray2, Collection<SignatureAndHashAlgorithm> collection, ProtocolVersion protocolVersion) throws IOException, GeneralSecurityException {
            ECParameterSpec eCParameterSpec;
            Object object;
            this.protocolVersion = protocolVersion;
            int n = handshakeInStream.getInt8();
            if (n == 3) {
                this.curveId = handshakeInStream.getInt16();
                if (!EllipticCurvesExtension.isSupported(this.curveId)) {
                    throw new SSLHandshakeException("Unsupported curveId: " + this.curveId);
                }
                object = EllipticCurvesExtension.getCurveOid(this.curveId);
                if (object == null) {
                    throw new SSLHandshakeException("Unknown named curve: " + this.curveId);
                }
                eCParameterSpec = JsseJce.getECParameterSpec((String)object);
                if (eCParameterSpec == null) {
                    throw new SSLHandshakeException("Unsupported curve: " + (String)object);
                }
            } else {
                throw new SSLHandshakeException("Unsupported ECCurveType: " + n);
            }
            this.pointBytes = handshakeInStream.getBytes8();
            object = JsseJce.decodePoint(this.pointBytes, eCParameterSpec.getCurve());
            KeyFactory keyFactory = JsseJce.getKeyFactory("EC");
            this.publicKey = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec((ECPoint)object, eCParameterSpec));
            if (publicKey == null) {
                return;
            }
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                int n2 = handshakeInStream.getInt8();
                int n3 = handshakeInStream.getInt8();
                this.preferableSignatureAlgorithm = SignatureAndHashAlgorithm.valueOf(n2, n3, 0);
                if (!collection.contains(this.preferableSignatureAlgorithm)) {
                    throw new SSLHandshakeException("Unsupported SignatureAndHashAlgorithm in ServerKeyExchange message: " + this.preferableSignatureAlgorithm);
                }
            }
            this.signatureBytes = handshakeInStream.getBytes16();
            Signature signature = protocolVersion.v >= ProtocolVersion.TLS12.v ? JsseJce.getSignature(this.preferableSignatureAlgorithm.getAlgorithmName()) : ECDH_ServerKeyExchange.getSignature(publicKey.getAlgorithm());
            signature.initVerify(publicKey);
            this.updateSignature(signature, byArray, byArray2);
            if (!signature.verify(this.signatureBytes)) {
                throw new SSLKeyException("Invalid signature on ECDH server key exchange message");
            }
        }

        ECPublicKey getPublicKey() {
            return this.publicKey;
        }

        private static Signature getSignature(String string) throws NoSuchAlgorithmException {
            switch (string) {
                case "EC": {
                    return JsseJce.getSignature("SHA1withECDSA");
                }
                case "RSA": {
                    return RSASignature.getInstance();
                }
            }
            throw new NoSuchAlgorithmException("neither an RSA or a EC key : " + string);
        }

        private void updateSignature(Signature signature, byte[] byArray, byte[] byArray2) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            signature.update((byte)3);
            signature.update((byte)(this.curveId >> 8));
            signature.update((byte)this.curveId);
            signature.update((byte)this.pointBytes.length);
            signature.update(this.pointBytes);
        }

        @Override
        int messageLength() {
            int n = 0;
            if (this.signatureBytes != null) {
                n = 2 + this.signatureBytes.length;
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    n += SignatureAndHashAlgorithm.sizeInRecord();
                }
            }
            return 4 + this.pointBytes.length + n;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(3);
            handshakeOutStream.putInt16(this.curveId);
            handshakeOutStream.putBytes8(this.pointBytes);
            if (this.signatureBytes != null) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    handshakeOutStream.putInt8(this.preferableSignatureAlgorithm.getHashValue());
                    handshakeOutStream.putInt8(this.preferableSignatureAlgorithm.getSignatureValue());
                }
                handshakeOutStream.putBytes16(this.signatureBytes);
            }
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ECDH ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                if (this.signatureBytes == null) {
                    printStream.println("Anonymous");
                } else if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    printStream.println("Signature Algorithm " + this.preferableSignatureAlgorithm.getAlgorithmName());
                }
                printStream.println("Server key: " + this.publicKey);
            }
        }
    }

    static final class Finished
    extends HandshakeMessage {
        static final int CLIENT = 1;
        static final int SERVER = 2;
        private static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
        private static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
        private byte[] verifyData;
        private ProtocolVersion protocolVersion;
        private CipherSuite cipherSuite;

        Finished(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, int n, SecretKey secretKey, CipherSuite cipherSuite) {
            this.protocolVersion = protocolVersion;
            this.cipherSuite = cipherSuite;
            this.verifyData = this.getFinished(handshakeHash, n, secretKey);
        }

        Finished(ProtocolVersion protocolVersion, HandshakeInStream handshakeInStream, CipherSuite cipherSuite) throws IOException {
            this.protocolVersion = protocolVersion;
            this.cipherSuite = cipherSuite;
            int n = protocolVersion.v >= ProtocolVersion.TLS10.v ? 12 : 36;
            this.verifyData = new byte[n];
            handshakeInStream.read(this.verifyData);
        }

        boolean verify(HandshakeHash handshakeHash, int n, SecretKey secretKey) {
            byte[] byArray = this.getFinished(handshakeHash, n, secretKey);
            return MessageDigest.isEqual(byArray, this.verifyData);
        }

        private byte[] getFinished(HandshakeHash handshakeHash, int n, SecretKey secretKey) {
            String string;
            byte[] byArray;
            if (n == 1) {
                byArray = SSL_CLIENT;
                string = "client finished";
            } else if (n == 2) {
                byArray = SSL_SERVER;
                string = "server finished";
            } else {
                throw new RuntimeException("Invalid sender: " + n);
            }
            if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
                try {
                    Object object;
                    CipherSuite.PRF pRF;
                    String string2;
                    byte[] byArray2;
                    if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                        byArray2 = handshakeHash.getFinishedHash();
                        string2 = "SunTls12Prf";
                        pRF = this.cipherSuite.prfAlg;
                    } else {
                        object = handshakeHash.getMD5Clone();
                        MessageDigest messageDigest = handshakeHash.getSHAClone();
                        byArray2 = new byte[36];
                        ((MessageDigest)object).digest(byArray2, 0, 16);
                        messageDigest.digest(byArray2, 16, 20);
                        string2 = "SunTlsPrf";
                        pRF = CipherSuite.PRF.P_NONE;
                    }
                    object = pRF.getPRFHashAlg();
                    int n2 = pRF.getPRFHashLength();
                    int n3 = pRF.getPRFBlockSize();
                    TlsPrfParameterSpec tlsPrfParameterSpec = new TlsPrfParameterSpec(secretKey, string, byArray2, 12, (String)object, n2, n3);
                    KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string2);
                    keyGenerator.init(tlsPrfParameterSpec);
                    SecretKey secretKey2 = keyGenerator.generateKey();
                    if (!"RAW".equals(secretKey2.getFormat())) {
                        throw new ProviderException("Invalid PRF output, format must be RAW. Format received: " + secretKey2.getFormat());
                    }
                    byte[] byArray3 = secretKey2.getEncoded();
                    return byArray3;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new RuntimeException("PRF failed", generalSecurityException);
                }
            }
            MessageDigest messageDigest = handshakeHash.getMD5Clone();
            MessageDigest messageDigest2 = handshakeHash.getSHAClone();
            Finished.updateDigest(messageDigest, byArray, MD5_pad1, MD5_pad2, secretKey);
            Finished.updateDigest(messageDigest2, byArray, SHA_pad1, SHA_pad2, secretKey);
            byte[] byArray4 = new byte[36];
            try {
                messageDigest.digest(byArray4, 0, 16);
                messageDigest2.digest(byArray4, 16, 20);
            }
            catch (DigestException digestException) {
                throw new RuntimeException("Digest failed", digestException);
            }
            return byArray4;
        }

        private static void updateDigest(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, byte[] byArray3, SecretKey secretKey) {
            messageDigest.update(byArray);
            CertificateVerify.updateDigest(messageDigest, byArray2, byArray3, secretKey);
        }

        byte[] getVerifyData() {
            return this.verifyData;
        }

        @Override
        int messageType() {
            return 20;
        }

        @Override
        int messageLength() {
            return this.verifyData.length;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.write(this.verifyData);
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** Finished");
            if (debug != null && Debug.isOn("verbose")) {
                Debug.println(printStream, "verify_data", this.verifyData);
                printStream.println("***");
            }
        }
    }

    static final class HelloRequest
    extends HandshakeMessage {
        @Override
        int messageType() {
            return 0;
        }

        HelloRequest() {
        }

        HelloRequest(HandshakeInStream handshakeInStream) throws IOException {
        }

        @Override
        int messageLength() {
            return 0;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** HelloRequest (empty)");
        }
    }

    static final class RSA_ServerKeyExchange
    extends ServerKeyExchange {
        private byte[] rsa_modulus;
        private byte[] rsa_exponent;
        private Signature signature;
        private byte[] signatureBytes;

        private void updateSignature(byte[] byArray, byte[] byArray2) throws SignatureException {
            this.signature.update(byArray);
            this.signature.update(byArray2);
            int n = this.rsa_modulus.length;
            this.signature.update((byte)(n >> 8));
            this.signature.update((byte)(n & 0xFF));
            this.signature.update(this.rsa_modulus);
            n = this.rsa_exponent.length;
            this.signature.update((byte)(n >> 8));
            this.signature.update((byte)(n & 0xFF));
            this.signature.update(this.rsa_exponent);
        }

        RSA_ServerKeyExchange(PublicKey publicKey, PrivateKey privateKey, RandomCookie randomCookie, RandomCookie randomCookie2, SecureRandom secureRandom) throws GeneralSecurityException {
            RSAPublicKeySpec rSAPublicKeySpec = JsseJce.getRSAPublicKeySpec(publicKey);
            this.rsa_modulus = RSA_ServerKeyExchange.toByteArray(rSAPublicKeySpec.getModulus());
            this.rsa_exponent = RSA_ServerKeyExchange.toByteArray(rSAPublicKeySpec.getPublicExponent());
            this.signature = RSASignature.getInstance();
            this.signature.initSign(privateKey, secureRandom);
            this.updateSignature(randomCookie.random_bytes, randomCookie2.random_bytes);
            this.signatureBytes = this.signature.sign();
        }

        RSA_ServerKeyExchange(HandshakeInStream handshakeInStream) throws IOException, NoSuchAlgorithmException {
            this.signature = RSASignature.getInstance();
            this.rsa_modulus = handshakeInStream.getBytes16();
            this.rsa_exponent = handshakeInStream.getBytes16();
            this.signatureBytes = handshakeInStream.getBytes16();
        }

        PublicKey getPublicKey() {
            try {
                KeyFactory keyFactory = JsseJce.getKeyFactory("RSA");
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(1, this.rsa_modulus), new BigInteger(1, this.rsa_exponent));
                return keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        boolean verify(PublicKey publicKey, RandomCookie randomCookie, RandomCookie randomCookie2) throws GeneralSecurityException {
            this.signature.initVerify(publicKey);
            this.updateSignature(randomCookie.random_bytes, randomCookie2.random_bytes);
            return this.signature.verify(this.signatureBytes);
        }

        @Override
        int messageLength() {
            return 6 + this.rsa_modulus.length + this.rsa_exponent.length + this.signatureBytes.length;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.rsa_modulus);
            handshakeOutStream.putBytes16(this.rsa_exponent);
            handshakeOutStream.putBytes16(this.signatureBytes);
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** RSA ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                Debug.println(printStream, "RSA Modulus", this.rsa_modulus);
                Debug.println(printStream, "RSA Public Exponent", this.rsa_exponent);
            }
        }
    }

    static final class ServerHello
    extends HandshakeMessage {
        ProtocolVersion protocolVersion;
        RandomCookie svr_random;
        SessionId sessionId;
        CipherSuite cipherSuite;
        byte compression_method;
        HelloExtensions extensions = new HelloExtensions();

        @Override
        int messageType() {
            return 2;
        }

        ServerHello() {
        }

        ServerHello(HandshakeInStream handshakeInStream, int n) throws IOException {
            this.protocolVersion = ProtocolVersion.valueOf(handshakeInStream.getInt8(), handshakeInStream.getInt8());
            this.svr_random = new RandomCookie(handshakeInStream);
            this.sessionId = new SessionId(handshakeInStream.getBytes8());
            this.sessionId.checkLength(this.protocolVersion);
            this.cipherSuite = CipherSuite.valueOf(handshakeInStream.getInt8(), handshakeInStream.getInt8());
            this.compression_method = (byte)handshakeInStream.getInt8();
            if (this.messageLength() != n) {
                this.extensions = new HelloExtensions(handshakeInStream);
            }
        }

        @Override
        int messageLength() {
            return 38 + this.sessionId.length() + this.extensions.length();
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(this.protocolVersion.major);
            handshakeOutStream.putInt8(this.protocolVersion.minor);
            this.svr_random.send(handshakeOutStream);
            handshakeOutStream.putBytes8(this.sessionId.getId());
            handshakeOutStream.putInt8(this.cipherSuite.id >> 8);
            handshakeOutStream.putInt8(this.cipherSuite.id & 0xFF);
            handshakeOutStream.putInt8(this.compression_method);
            this.extensions.send(handshakeOutStream);
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ServerHello, " + this.protocolVersion);
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("RandomCookie:  ");
                this.svr_random.print(printStream);
                printStream.print("Session ID:  ");
                printStream.println(this.sessionId);
                printStream.println("Cipher Suite: " + this.cipherSuite);
                printStream.println("Compression Method: " + this.compression_method);
                this.extensions.print(printStream);
                printStream.println("***");
            }
        }
    }

    static final class ServerHelloDone
    extends HandshakeMessage {
        @Override
        int messageType() {
            return 14;
        }

        ServerHelloDone() {
        }

        ServerHelloDone(HandshakeInStream handshakeInStream) {
        }

        @Override
        int messageLength() {
            return 0;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ServerHelloDone");
        }
    }

    static abstract class ServerKeyExchange
    extends HandshakeMessage {
        ServerKeyExchange() {
        }

        @Override
        int messageType() {
            return 12;
        }
    }
}

