/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class Wrapper
extends Enum<Wrapper> {
    public static final /* enum */ Wrapper BOOLEAN = new Wrapper(Boolean.class, Boolean.TYPE, 'Z', false, new boolean[0], Format.unsigned(1));
    public static final /* enum */ Wrapper BYTE = new Wrapper(Byte.class, Byte.TYPE, 'B', (byte)0, new byte[0], Format.signed(8));
    public static final /* enum */ Wrapper SHORT = new Wrapper(Short.class, Short.TYPE, 'S', (short)0, new short[0], Format.signed(16));
    public static final /* enum */ Wrapper CHAR = new Wrapper(Character.class, Character.TYPE, 'C', Character.valueOf('\u0000'), new char[0], Format.unsigned(16));
    public static final /* enum */ Wrapper INT = new Wrapper(Integer.class, Integer.TYPE, 'I', 0, new int[0], Format.signed(32));
    public static final /* enum */ Wrapper LONG = new Wrapper(Long.class, Long.TYPE, 'J', 0L, new long[0], Format.signed(64));
    public static final /* enum */ Wrapper FLOAT = new Wrapper(Float.class, Float.TYPE, 'F', Float.valueOf(0.0f), new float[0], Format.floating(32));
    public static final /* enum */ Wrapper DOUBLE = new Wrapper(Double.class, Double.TYPE, 'D', 0.0, new double[0], Format.floating(64));
    public static final /* enum */ Wrapper OBJECT = new Wrapper(Object.class, Object.class, 'L', null, new Object[0], Format.other(1));
    public static final /* enum */ Wrapper VOID = new Wrapper(Void.class, Void.TYPE, 'V', null, null, Format.other(0));
    private final Class<?> wrapperType;
    private final Class<?> primitiveType;
    private final char basicTypeChar;
    private final Object zero;
    private final Object emptyArray;
    private final int format;
    private final String wrapperSimpleName;
    private final String primitiveSimpleName;
    private static final Wrapper[] FROM_PRIM;
    private static final Wrapper[] FROM_WRAP;
    private static final Wrapper[] FROM_CHAR;
    private static final /* synthetic */ Wrapper[] $VALUES;

    public static Wrapper[] values() {
        return (Wrapper[])$VALUES.clone();
    }

    public static Wrapper valueOf(String string) {
        return Enum.valueOf(Wrapper.class, string);
    }

    private Wrapper(Class<?> clazz, Class<?> clazz2, char c, Object object, Object object2, int n2) {
        this.wrapperType = clazz;
        this.primitiveType = clazz2;
        this.basicTypeChar = c;
        this.zero = object;
        this.emptyArray = object2;
        this.format = n2;
        this.wrapperSimpleName = clazz.getSimpleName();
        this.primitiveSimpleName = clazz2.getSimpleName();
    }

    public String detailString() {
        return this.wrapperSimpleName + Arrays.asList(this.wrapperType, this.primitiveType, Character.valueOf(this.basicTypeChar), this.zero, "0x" + Integer.toHexString(this.format));
    }

    public int bitWidth() {
        return this.format >> 2 & 0x3FF;
    }

    public int stackSlots() {
        return this.format >> 0 & 3;
    }

    public boolean isSingleWord() {
        return (this.format & 1) != 0;
    }

    public boolean isDoubleWord() {
        return (this.format & 2) != 0;
    }

    public boolean isNumeric() {
        return (this.format & 0xFFFFFFFC) != 0;
    }

    public boolean isIntegral() {
        return this.isNumeric() && this.format < 4225;
    }

    public boolean isSubwordOrInt() {
        return this.isIntegral() && this.isSingleWord();
    }

    public boolean isSigned() {
        return this.format < 0;
    }

    public boolean isUnsigned() {
        return this.format >= 5 && this.format < 4225;
    }

    public boolean isFloating() {
        return this.format >= 4225;
    }

    public boolean isOther() {
        return (this.format & 0xFFFFFFFC) == 0;
    }

    public boolean isConvertibleFrom(Wrapper wrapper) {
        boolean bl;
        if (this == wrapper) {
            return true;
        }
        if (this.compareTo(wrapper) < 0) {
            return false;
        }
        boolean bl2 = bl = (this.format & wrapper.format & 0xFFFFF000) != 0;
        if (!bl) {
            if (this.isOther()) {
                return true;
            }
            return wrapper.format == 65;
        }
        assert (this.isFloating() || this.isSigned());
        assert (wrapper.isFloating() || wrapper.isSigned());
        return true;
    }

    private static boolean checkConvertibleFrom() {
        for (Wrapper wrapper : Wrapper.values()) {
            assert (wrapper.isConvertibleFrom(wrapper));
            assert (VOID.isConvertibleFrom(wrapper));
            if (wrapper != VOID) {
                assert (OBJECT.isConvertibleFrom(wrapper));
                assert (!wrapper.isConvertibleFrom(VOID));
            }
            if (wrapper != CHAR) {
                assert (!CHAR.isConvertibleFrom(wrapper));
                if (!wrapper.isConvertibleFrom(INT)) assert (!wrapper.isConvertibleFrom(CHAR));
            }
            if (wrapper != BOOLEAN) {
                assert (!BOOLEAN.isConvertibleFrom(wrapper));
                if (wrapper != VOID && wrapper != OBJECT) assert (!wrapper.isConvertibleFrom(BOOLEAN));
            }
            if (wrapper.isSigned()) {
                for (Wrapper wrapper2 : Wrapper.values()) {
                    if (wrapper != wrapper2 && (wrapper2.isFloating() ? !$assertionsDisabled && wrapper.isConvertibleFrom(wrapper2) : wrapper2.isSigned() && (wrapper.compareTo(wrapper2) < 0 ? !$assertionsDisabled && wrapper.isConvertibleFrom(wrapper2) : !$assertionsDisabled && !wrapper.isConvertibleFrom(wrapper2)))) {
                        throw new AssertionError();
                    }
                }
            }
            if (!wrapper.isFloating()) continue;
            for (Wrapper wrapper2 : Wrapper.values()) {
                if (wrapper != wrapper2 && (wrapper2.isSigned() ? !$assertionsDisabled && !wrapper.isConvertibleFrom(wrapper2) : wrapper2.isFloating() && (wrapper.compareTo(wrapper2) < 0 ? !$assertionsDisabled && wrapper.isConvertibleFrom(wrapper2) : !$assertionsDisabled && !wrapper.isConvertibleFrom(wrapper2)))) {
                    throw new AssertionError();
                }
            }
        }
        return true;
    }

    public Object zero() {
        return this.zero;
    }

    public <T> T zero(Class<T> clazz) {
        return this.convert(this.zero, clazz);
    }

    public static Wrapper forPrimitiveType(Class<?> clazz) {
        Wrapper wrapper = Wrapper.findPrimitiveType(clazz);
        if (wrapper != null) {
            return wrapper;
        }
        if (clazz.isPrimitive()) {
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not primitive: " + clazz);
    }

    static Wrapper findPrimitiveType(Class<?> clazz) {
        Wrapper wrapper = FROM_PRIM[Wrapper.hashPrim(clazz)];
        if (wrapper != null && wrapper.primitiveType == clazz) {
            return wrapper;
        }
        return null;
    }

    public static Wrapper forWrapperType(Class<?> clazz) {
        Wrapper wrapper = Wrapper.findWrapperType(clazz);
        if (wrapper != null) {
            return wrapper;
        }
        for (Wrapper wrapper2 : Wrapper.values()) {
            if (wrapper2.wrapperType != clazz) continue;
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not wrapper: " + clazz);
    }

    static Wrapper findWrapperType(Class<?> clazz) {
        Wrapper wrapper = FROM_WRAP[Wrapper.hashWrap(clazz)];
        if (wrapper != null && wrapper.wrapperType == clazz) {
            return wrapper;
        }
        return null;
    }

    public static Wrapper forBasicType(char c) {
        Wrapper wrapper = FROM_CHAR[Wrapper.hashChar(c)];
        if (wrapper != null && wrapper.basicTypeChar == c) {
            return wrapper;
        }
        for (Wrapper wrapper2 : Wrapper.values()) {
            if (wrapper.basicTypeChar != c) continue;
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not basic type char: " + c);
    }

    public static Wrapper forBasicType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return Wrapper.forPrimitiveType(clazz);
        }
        return OBJECT;
    }

    private static int hashPrim(Class<?> clazz) {
        String string = clazz.getName();
        if (string.length() < 3) {
            return 0;
        }
        return (string.charAt(0) + string.charAt(2)) % 16;
    }

    private static int hashWrap(Class<?> clazz) {
        String string = clazz.getName();
        assert (10 == "java.lang.".length());
        if (string.length() < 13) {
            return 0;
        }
        return (3 * string.charAt(11) + string.charAt(12)) % 16;
    }

    private static int hashChar(char c) {
        return (c + (c >> 1)) % 16;
    }

    public Class<?> primitiveType() {
        return this.primitiveType;
    }

    public Class<?> wrapperType() {
        return this.wrapperType;
    }

    public <T> Class<T> wrapperType(Class<T> clazz) {
        if (clazz == this.wrapperType) {
            return clazz;
        }
        if (clazz == this.primitiveType || this.wrapperType == Object.class || clazz.isInterface()) {
            return Wrapper.forceType(this.wrapperType, clazz);
        }
        throw Wrapper.newClassCastException(clazz, this.primitiveType);
    }

    private static ClassCastException newClassCastException(Class<?> clazz, Class<?> clazz2) {
        return new ClassCastException(clazz + " is not compatible with " + clazz2);
    }

    public static <T> Class<T> asWrapperType(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            return Wrapper.forPrimitiveType(clazz).wrapperType(clazz);
        }
        return clazz;
    }

    public static <T> Class<T> asPrimitiveType(Class<T> clazz) {
        Wrapper wrapper = Wrapper.findWrapperType(clazz);
        if (wrapper != null) {
            return Wrapper.forceType(wrapper.primitiveType(), clazz);
        }
        return clazz;
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return Wrapper.findWrapperType(clazz) != null;
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public static char basicTypeChar(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return 'L';
        }
        return Wrapper.forPrimitiveType(clazz).basicTypeChar();
    }

    public char basicTypeChar() {
        return this.basicTypeChar;
    }

    public String wrapperSimpleName() {
        return this.wrapperSimpleName;
    }

    public String primitiveSimpleName() {
        return this.primitiveSimpleName;
    }

    public <T> T cast(Object object, Class<T> clazz) {
        return this.convert(object, clazz, true);
    }

    public <T> T convert(Object object, Class<T> clazz) {
        return this.convert(object, clazz, false);
    }

    private <T> T convert(Object object, Class<T> clazz, boolean bl) {
        Class<?> clazz2;
        if (this == OBJECT) {
            assert (!clazz.isPrimitive());
            if (!clazz.isInterface()) {
                clazz.cast(object);
            }
            Object object2 = object;
            return (T)object2;
        }
        Class<T> clazz3 = this.wrapperType(clazz);
        if (clazz3.isInstance(object)) {
            return clazz3.cast(object);
        }
        if (!bl) {
            clazz2 = object.getClass();
            Wrapper wrapper = Wrapper.findWrapperType(clazz2);
            if (wrapper == null || !this.isConvertibleFrom(wrapper)) {
                throw Wrapper.newClassCastException(clazz3, clazz2);
            }
        } else if (object == null) {
            Object object3 = this.zero;
            return (T)object3;
        }
        clazz2 = this.wrap(object);
        assert ((clazz2 == null ? Void.class : clazz2.getClass()) == clazz3);
        return (T)clazz2;
    }

    static <T> Class<T> forceType(Class<?> clazz, Class<T> clazz2) {
        boolean bl;
        boolean bl2 = bl = clazz == clazz2 || clazz.isPrimitive() && Wrapper.forPrimitiveType(clazz) == Wrapper.findWrapperType(clazz2) || clazz2.isPrimitive() && Wrapper.forPrimitiveType(clazz2) == Wrapper.findWrapperType(clazz) || clazz == Object.class && !clazz2.isPrimitive();
        if (!bl) {
            System.out.println(clazz + " <= " + clazz2);
        }
        assert (clazz == clazz2 || clazz.isPrimitive() && Wrapper.forPrimitiveType(clazz) == Wrapper.findWrapperType(clazz2) || clazz2.isPrimitive() && Wrapper.forPrimitiveType(clazz2) == Wrapper.findWrapperType(clazz) || clazz == Object.class && !clazz2.isPrimitive());
        Class<?> clazz3 = clazz;
        return clazz3;
    }

    public Object wrap(Object object) {
        switch (this.basicTypeChar) {
            case 'L': {
                return object;
            }
            case 'V': {
                return null;
            }
        }
        Number number = Wrapper.numberValue(object);
        switch (this.basicTypeChar) {
            case 'I': {
                return number.intValue();
            }
            case 'J': {
                return number.longValue();
            }
            case 'F': {
                return Float.valueOf(number.floatValue());
            }
            case 'D': {
                return number.doubleValue();
            }
            case 'S': {
                return (short)number.intValue();
            }
            case 'B': {
                return (byte)number.intValue();
            }
            case 'C': {
                return Character.valueOf((char)number.intValue());
            }
            case 'Z': {
                return Wrapper.boolValue(number.byteValue());
            }
        }
        throw new InternalError("bad wrapper");
    }

    public Object wrap(int n) {
        if (this.basicTypeChar == 'L') {
            return n;
        }
        switch (this.basicTypeChar) {
            case 'L': {
                throw Wrapper.newIllegalArgumentException("cannot wrap to object type");
            }
            case 'V': {
                return null;
            }
            case 'I': {
                return n;
            }
            case 'J': {
                return (long)n;
            }
            case 'F': {
                return Float.valueOf(n);
            }
            case 'D': {
                return (double)n;
            }
            case 'S': {
                return (short)n;
            }
            case 'B': {
                return (byte)n;
            }
            case 'C': {
                return Character.valueOf((char)n);
            }
            case 'Z': {
                return Wrapper.boolValue((byte)n);
            }
        }
        throw new InternalError("bad wrapper");
    }

    private static Number numberValue(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Character) {
            return (int)((Character)object).charValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        return (Number)object;
    }

    private static boolean boolValue(byte by) {
        return (by = (byte)(by & 1)) != 0;
    }

    private static RuntimeException newIllegalArgumentException(String string, Object object) {
        return Wrapper.newIllegalArgumentException(string + object);
    }

    private static RuntimeException newIllegalArgumentException(String string) {
        return new IllegalArgumentException(string);
    }

    public Object makeArray(int n) {
        return Array.newInstance(this.primitiveType, n);
    }

    public Class<?> arrayType() {
        return this.emptyArray.getClass();
    }

    public void copyArrayUnboxing(Object[] objectArray, int n, Object object, int n2, int n3) {
        if (object.getClass() != this.arrayType()) {
            this.arrayType().cast(object);
        }
        for (int i = 0; i < n3; ++i) {
            Object object2 = objectArray[i + n];
            object2 = this.convert(object2, this.primitiveType);
            Array.set(object, i + n2, object2);
        }
    }

    public void copyArrayBoxing(Object object, int n, Object[] objectArray, int n2, int n3) {
        if (object.getClass() != this.arrayType()) {
            this.arrayType().cast(object);
        }
        for (int i = 0; i < n3; ++i) {
            Object object2 = Array.get(object, i + n);
            assert (object2.getClass() == this.wrapperType);
            objectArray[i + n2] = object2;
        }
    }

    static {
        $VALUES = new Wrapper[]{BOOLEAN, BYTE, SHORT, CHAR, INT, LONG, FLOAT, DOUBLE, OBJECT, VOID};
        assert (Wrapper.checkConvertibleFrom());
        FROM_PRIM = new Wrapper[16];
        FROM_WRAP = new Wrapper[16];
        FROM_CHAR = new Wrapper[16];
        for (Wrapper wrapper : Wrapper.values()) {
            int n = Wrapper.hashPrim(wrapper.primitiveType);
            int n2 = Wrapper.hashWrap(wrapper.wrapperType);
            int n3 = Wrapper.hashChar(wrapper.basicTypeChar);
            assert (FROM_PRIM[n] == null);
            assert (FROM_WRAP[n2] == null);
            assert (FROM_CHAR[n3] == null);
            Wrapper.FROM_PRIM[n] = wrapper;
            Wrapper.FROM_WRAP[n2] = wrapper;
            Wrapper.FROM_CHAR[n3] = wrapper;
        }
    }

    private static abstract class Format {
        static final int SLOT_SHIFT = 0;
        static final int SIZE_SHIFT = 2;
        static final int KIND_SHIFT = 12;
        static final int SIGNED = -4096;
        static final int UNSIGNED = 0;
        static final int FLOATING = 4096;
        static final int SLOT_MASK = 3;
        static final int SIZE_MASK = 1023;
        static final int INT = -3967;
        static final int SHORT = -4031;
        static final int BOOLEAN = 5;
        static final int CHAR = 65;
        static final int FLOAT = 4225;
        static final int VOID = 0;
        static final int NUM_MASK = -4;

        private Format() {
        }

        static int format(int n, int n2, int n3) {
            assert (n >> 12 << 12 == n);
            assert ((n2 & n2 - 1) == 0);
            assert (n == -4096 ? n2 > 0 : (n == 0 ? n2 > 0 : n == 4096 && (n2 == 32 || n2 == 64)));
            assert (n3 == 2 ? n2 == 64 : n3 == 1 && n2 <= 32);
            return n | n2 << 2 | n3 << 0;
        }

        static int signed(int n) {
            return Format.format(-4096, n, n > 32 ? 2 : 1);
        }

        static int unsigned(int n) {
            return Format.format(0, n, n > 32 ? 2 : 1);
        }

        static int floating(int n) {
            return Format.format(4096, n, n > 32 ? 2 : 1);
        }

        static int other(int n) {
            return n << 0;
        }
    }
}

