/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.dump;

import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.commons.xmlutil.Converter;
import com.sun.xml.internal.ws.dump.MessageDumper;
import com.sun.xml.internal.ws.dump.MessageDumpingFeature;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

final class MessageDumpingTube
extends AbstractFilterTubeImpl {
    static final String DEFAULT_MSGDUMP_LOGGING_ROOT = "com.sun.xml.internal.ws.messagedump";
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private final MessageDumper messageDumper;
    private final int tubeId;
    private final MessageDumpingFeature messageDumpingFeature;

    MessageDumpingTube(Tube tube, MessageDumpingFeature messageDumpingFeature) {
        super(tube);
        this.messageDumpingFeature = messageDumpingFeature;
        this.tubeId = ID_GENERATOR.incrementAndGet();
        this.messageDumper = new MessageDumper("MesageDumpingTube", Logger.getLogger(messageDumpingFeature.getMessageLoggingRoot()), messageDumpingFeature.getMessageLoggingLevel());
    }

    MessageDumpingTube(MessageDumpingTube messageDumpingTube, TubeCloner tubeCloner) {
        super(messageDumpingTube, tubeCloner);
        this.messageDumpingFeature = messageDumpingTube.messageDumpingFeature;
        this.tubeId = ID_GENERATOR.incrementAndGet();
        this.messageDumper = messageDumpingTube.messageDumper;
    }

    @Override
    public MessageDumpingTube copy(TubeCloner tubeCloner) {
        return new MessageDumpingTube(this, tubeCloner);
    }

    @Override
    public NextAction processRequest(Packet packet) {
        this.dump(MessageDumper.MessageType.Request, Converter.toString(packet), Fiber.current().owner.id);
        return super.processRequest(packet);
    }

    @Override
    public NextAction processResponse(Packet packet) {
        this.dump(MessageDumper.MessageType.Response, Converter.toString(packet), Fiber.current().owner.id);
        return super.processResponse(packet);
    }

    @Override
    public NextAction processException(Throwable throwable) {
        this.dump(MessageDumper.MessageType.Exception, Converter.toString(throwable), Fiber.current().owner.id);
        return super.processException(throwable);
    }

    protected final void dump(MessageDumper.MessageType messageType, String string, String string2) {
        String string3;
        if (this.messageDumpingFeature.getMessageLoggingStatus()) {
            this.messageDumper.setLoggingLevel(this.messageDumpingFeature.getMessageLoggingLevel());
            string3 = this.messageDumper.dump(messageType, MessageDumper.ProcessingState.Received, string, this.tubeId, string2);
        } else {
            string3 = this.messageDumper.createLogMessage(messageType, MessageDumper.ProcessingState.Received, this.tubeId, string2, string);
        }
        this.messageDumpingFeature.offerMessage(string3);
    }
}

