/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class ParameterAnnotationEntry
implements Node {
    private final AnnotationEntry[] annotation_table;

    ParameterAnnotationEntry(DataInput dataInput, ConstantPool constantPool) throws IOException {
        int n = dataInput.readUnsignedShort();
        this.annotation_table = new AnnotationEntry[n];
        for (int i = 0; i < n; ++i) {
            this.annotation_table[i] = AnnotationEntry.read(dataInput, constantPool, false);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitParameterAnnotationEntry(this);
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotation_table;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.annotation_table.length);
        for (AnnotationEntry annotationEntry : this.annotation_table) {
            annotationEntry.dump(dataOutputStream);
        }
    }

    public static ParameterAnnotationEntry[] createParameterAnnotationEntries(Attribute[] attributeArray) {
        ArrayList arrayList = new ArrayList(attributeArray.length);
        for (Attribute attribute : attributeArray) {
            if (!(attribute instanceof ParameterAnnotations)) continue;
            ParameterAnnotations parameterAnnotations = (ParameterAnnotations)attribute;
            Collections.addAll(arrayList, parameterAnnotations.getParameterAnnotationEntries());
        }
        return arrayList.toArray(new ParameterAnnotationEntry[arrayList.size()]);
    }
}

