/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ConstantCP
extends Constant {
    private int class_index;
    private int name_and_type_index;

    public ConstantCP(ConstantCP constantCP) {
        this(constantCP.getTag(), constantCP.getClassIndex(), constantCP.getNameAndTypeIndex());
    }

    ConstantCP(byte by, DataInput dataInput) throws IOException {
        this(by, dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
    }

    protected ConstantCP(byte by, int n, int n2) {
        super(by);
        this.class_index = n;
        this.name_and_type_index = n2;
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeShort(this.class_index);
        dataOutputStream.writeShort(this.name_and_type_index);
    }

    public final int getClassIndex() {
        return this.class_index;
    }

    public final void setClassIndex(int n) {
        this.class_index = n;
    }

    public final int getNameAndTypeIndex() {
        return this.name_and_type_index;
    }

    public final void setNameAndTypeIndex(int n) {
        this.name_and_type_index = n;
    }

    public String getClass(ConstantPool constantPool) {
        return constantPool.constantToString(this.class_index, (byte)7);
    }

    @Override
    public String toString() {
        return super.toString() + "(class_index = " + this.class_index + ", name_and_type_index = " + this.name_and_type_index + ")";
    }
}

