/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Annotations;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.classfile.ElementValuePair;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationEntry
implements Node {
    private final int type_index;
    private final ConstantPool constant_pool;
    private final boolean isRuntimeVisible;
    private List<ElementValuePair> element_value_pairs;

    public static AnnotationEntry read(DataInput dataInput, ConstantPool constantPool, boolean bl) throws IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(dataInput.readUnsignedShort(), constantPool, bl);
        int n = dataInput.readUnsignedShort();
        annotationEntry.element_value_pairs = new ArrayList<ElementValuePair>();
        for (int i = 0; i < n; ++i) {
            annotationEntry.element_value_pairs.add(new ElementValuePair(dataInput.readUnsignedShort(), ElementValue.readElementValue(dataInput, constantPool), constantPool));
        }
        return annotationEntry;
    }

    public AnnotationEntry(int n, ConstantPool constantPool, boolean bl) {
        this.type_index = n;
        this.constant_pool = constantPool;
        this.isRuntimeVisible = bl;
    }

    public int getTypeIndex() {
        return this.type_index;
    }

    public ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitAnnotationEntry(this);
    }

    public String getAnnotationType() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.type_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public int getAnnotationTypeIndex() {
        return this.type_index;
    }

    public final int getNumElementValuePairs() {
        return this.element_value_pairs.size();
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.element_value_pairs.toArray(new ElementValuePair[this.element_value_pairs.size()]);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.type_index);
        dataOutputStream.writeShort(this.element_value_pairs.size());
        for (ElementValuePair elementValuePair : this.element_value_pairs) {
            elementValuePair.dump(dataOutputStream);
        }
    }

    public void addElementNameValuePair(ElementValuePair elementValuePair) {
        this.element_value_pairs.add(elementValuePair);
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@");
        stringBuilder.append(this.getAnnotationType());
        ElementValuePair[] elementValuePairArray = this.getElementValuePairs();
        if (elementValuePairArray.length > 0) {
            stringBuilder.append("(");
            for (ElementValuePair elementValuePair : elementValuePairArray) {
                stringBuilder.append(elementValuePair.toShortString());
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toShortString();
    }

    public static AnnotationEntry[] createAnnotationEntries(Attribute[] attributeArray) {
        ArrayList arrayList = new ArrayList(attributeArray.length);
        for (Attribute attribute : attributeArray) {
            if (!(attribute instanceof Annotations)) continue;
            Annotations annotations = (Annotations)attribute;
            Collections.addAll(arrayList, annotations.getAnnotationEntries());
        }
        return arrayList.toArray(new AnnotationEntry[arrayList.size()]);
    }
}

